/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner.MiningTask;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class IndustrialMiner
extends MultiBlockMachine {
    protected final Map<Location, MiningTask> activeMiners = new HashMap<Location, MiningTask>();
    protected final List<MachineFuel> fuelTypes = new ArrayList<MachineFuel>();
    private final ItemSetting<Boolean> canMineAncientDebris = new ItemSetting<Boolean>(this, "can-mine-ancient-debris", false);
    private final ItemSetting<Boolean> canMineDeepslateOres = new ItemSetting<Boolean>(this, "can-mine-deepslate-ores", true);
    private final boolean silkTouch;
    private final int range;

    @ParametersAreNonnullByDefault
    public IndustrialMiner(ItemGroup itemGroup, SlimefunItemStack item, Material baseMaterial, boolean silkTouch, int range) {
        super(itemGroup, item, new ItemStack[]{null, null, null, new CustomItemStack(Material.PISTON, "Piston (facing up)", new String[0]), new ItemStack(Material.CHEST), new CustomItemStack(Material.PISTON, "Piston (facing up)", new String[0]), new ItemStack(baseMaterial), new ItemStack(Material.BLAST_FURNACE), new ItemStack(baseMaterial)}, BlockFace.UP);
        this.range = range;
        this.silkTouch = silkTouch;
        this.registerDefaultFuelTypes();
        this.addItemSetting(this.canMineAncientDebris);
        this.addItemSetting(this.canMineDeepslateOres);
    }

    public boolean hasSilkTouch() {
        return this.silkTouch;
    }

    public int getRange() {
        return this.range;
    }

    protected void registerDefaultFuelTypes() {
        this.fuelTypes.add(new MachineFuel(4, new ItemStack(Material.COAL)));
        this.fuelTypes.add(new MachineFuel(4, new ItemStack(Material.CHARCOAL)));
        this.fuelTypes.add(new MachineFuel(40, new ItemStack(Material.COAL_BLOCK)));
        this.fuelTypes.add(new MachineFuel(10, new ItemStack(Material.DRIED_KELP_BLOCK)));
        this.fuelTypes.add(new MachineFuel(4, new ItemStack(Material.BLAZE_ROD)));
        for (Material mat : Tag.LOGS.getValues()) {
            this.fuelTypes.add(new MachineFuel(1, new ItemStack(mat)));
        }
    }

    @Nonnull
    public ItemStack getOutcome(@Nonnull Material ore) {
        if (this.hasSilkTouch()) {
            return new ItemStack(ore);
        }
        MinecraftVersion minecraftVersion = Slimefun.getMinecraftVersion();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (minecraftVersion.isAtLeast(MinecraftVersion.MINECRAFT_1_17)) {
            switch (ore) {
                case DEEPSLATE_COAL_ORE: {
                    return new ItemStack(Material.COAL);
                }
                case DEEPSLATE_DIAMOND_ORE: {
                    return new ItemStack(Material.DIAMOND);
                }
                case DEEPSLATE_EMERALD_ORE: {
                    return new ItemStack(Material.EMERALD);
                }
                case DEEPSLATE_REDSTONE_ORE: {
                    return new ItemStack(Material.REDSTONE, 4 + ((Random)random).nextInt(2));
                }
                case DEEPSLATE_LAPIS_ORE: {
                    return new ItemStack(Material.LAPIS_LAZULI, 4 + ((Random)random).nextInt(4));
                }
                case COPPER_ORE: 
                case DEEPSLATE_COPPER_ORE: {
                    return new ItemStack(Material.RAW_COPPER);
                }
                case IRON_ORE: 
                case DEEPSLATE_IRON_ORE: {
                    return new ItemStack(Material.RAW_IRON);
                }
                case GOLD_ORE: 
                case DEEPSLATE_GOLD_ORE: {
                    return new ItemStack(Material.RAW_GOLD);
                }
            }
        }
        if (minecraftVersion.isAtLeast(MinecraftVersion.MINECRAFT_1_16) && ore == Material.NETHER_GOLD_ORE) {
            return new ItemStack(Material.GOLD_NUGGET, 2 + ((Random)random).nextInt(4));
        }
        switch (ore) {
            case COAL_ORE: {
                return new ItemStack(Material.COAL);
            }
            case DIAMOND_ORE: {
                return new ItemStack(Material.DIAMOND);
            }
            case EMERALD_ORE: {
                return new ItemStack(Material.EMERALD);
            }
            case REDSTONE_ORE: {
                return new ItemStack(Material.REDSTONE, 4 + ((Random)random).nextInt(2));
            }
            case LAPIS_ORE: {
                return new ItemStack(Material.LAPIS_LAZULI, 4 + ((Random)random).nextInt(4));
            }
            case NETHER_QUARTZ_ORE: {
                return new ItemStack(Material.QUARTZ);
            }
        }
        return new ItemStack(ore);
    }

    public void addFuelType(int ores, @Nonnull ItemStack item) {
        Validate.isTrue((ores > 1 && ores % 2 == 0 ? 1 : 0) != 0, (String)"The amount of ores must be at least 2 and a multiple of 2.");
        Validate.notNull((Object)item, (String)"The fuel item cannot be null");
        this.fuelTypes.add(new MachineFuel(ores / 2, item));
    }

    @Override
    @Nonnull
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.generator";
    }

    @Override
    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MachineFuel fuel : this.fuelTypes) {
            ItemStack item = fuel.getInput().clone();
            ItemMeta im = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColors.color("&8\u21e8 &7Lasts for max. " + fuel.getTicks() + " Ores"));
            im.setLore(lore);
            item.setItemMeta(im);
            list.add(item);
        }
        return list;
    }

    @Override
    public void onInteract(Player p, Block b) {
        if (this.activeMiners.containsKey(b.getLocation())) {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.INDUSTRIAL_MINER.already-running");
            return;
        }
        Block chest = b.getRelative(BlockFace.UP);
        Block[] pistons = this.findPistons(chest);
        int mod = this.getRange();
        Block start = b.getRelative(-mod, -1, -mod);
        Block end = b.getRelative(mod, -1, mod);
        MiningTask task = new MiningTask(this, p.getUniqueId(), chest, pistons, start, end);
        task.start(b);
    }

    @Nonnull
    private Block[] findPistons(@Nonnull Block chest) {
        Block northern = chest.getRelative(BlockFace.NORTH);
        if (northern.getType() == Material.PISTON) {
            return new Block[]{northern, chest.getRelative(BlockFace.SOUTH)};
        }
        return new Block[]{chest.getRelative(BlockFace.WEST), chest.getRelative(BlockFace.EAST)};
    }

    public boolean canMine(@Nonnull Material type) {
        MinecraftVersion version = Slimefun.getMinecraftVersion();
        if (version.isAtLeast(MinecraftVersion.MINECRAFT_1_16) && type == Material.ANCIENT_DEBRIS) {
            return this.canMineAncientDebris.getValue();
        }
        if (version.isAtLeast(MinecraftVersion.MINECRAFT_1_17) && SlimefunTag.DEEPSLATE_ORES.isTagged(type)) {
            return this.canMineDeepslateOres.getValue();
        }
        return SlimefunTag.INDUSTRIAL_MINER_ORES.isTagged(type);
    }
}

