/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.LoopIterator;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.plugin.Plugin;

public class AsyncRecipeChoiceTask
implements Runnable {
    private static final int UPDATE_INTERVAL = 14;
    private final Map<Integer, LoopIterator<Material>> iterators = new HashMap<Integer, LoopIterator<Material>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Inventory inventory;
    private int id;

    public void start(@Nonnull Inventory inv) {
        Validate.notNull((Object)inv, (String)"Inventory must not be null");
        this.inventory = inv;
        this.id = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SlimefunPlugin.instance(), (Runnable)this, 0L, 14L).getTaskId();
    }

    public void add(int slot, @Nonnull RecipeChoice.MaterialChoice choice) {
        Validate.notNull((Object)choice, (String)"Cannot add a null RecipeChoice");
        this.lock.writeLock().lock();
        try {
            this.iterators.put(slot, new LoopIterator(choice.getChoices()));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void add(int slot, @Nonnull Tag<Material> tag) {
        Validate.notNull(tag, (String)"Cannot add a null Tag");
        this.lock.writeLock().lock();
        try {
            this.iterators.put(slot, new LoopIterator(tag.getValues()));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.iterators.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.iterators.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void run() {
        if (this.inventory.getViewers().isEmpty()) {
            Bukkit.getScheduler().cancelTask(this.id);
            return;
        }
        this.lock.readLock().lock();
        try {
            for (Map.Entry<Integer, LoopIterator<Material>> entry : this.iterators.entrySet()) {
                this.inventory.setItem(entry.getKey().intValue(), new ItemStack(entry.getValue().next()));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

