/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.api.events.AndroidFarmEvent;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidInstance;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ProgrammableAndroid;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class FarmerAndroid
extends ProgrammableAndroid {
    @ParametersAreNonnullByDefault
    public FarmerAndroid(Category category, int tier, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, tier, item, recipeType, recipe);
    }

    @Override
    public AndroidType getAndroidType() {
        return this.getTier() == 1 ? AndroidType.FARMER : AndroidType.ADVANCED_FARMER;
    }

    @Override
    protected void farm(Block b, BlockMenu menu, Block block, boolean isAdvanced) {
        Material blockType = block.getType();
        BlockData data = block.getBlockData();
        ItemStack drop = null;
        if (!block.getWorld().getWorldBorder().isInside(block.getLocation())) {
            return;
        }
        if (data instanceof Ageable && ((Ageable)data).getAge() >= ((Ageable)data).getMaximumAge()) {
            drop = this.getDropFromCrop(blockType);
        }
        AndroidInstance instance = new AndroidInstance(this, b);
        AndroidFarmEvent event = new AndroidFarmEvent(block, instance, isAdvanced, drop);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled() && (drop = event.getDrop()) != null && menu.pushItem(drop, this.getOutputSlots()) == null) {
            block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)blockType);
            if (data instanceof Ageable) {
                ((Ageable)data).setAge(0);
                block.setBlockData(data);
            }
        }
    }

    private ItemStack getDropFromCrop(Material crop) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        switch (crop) {
            case WHEAT: {
                return new ItemStack(Material.WHEAT, ((Random)random).nextInt(2) + 1);
            }
            case POTATOES: {
                return new ItemStack(Material.POTATO, ((Random)random).nextInt(3) + 1);
            }
            case CARROTS: {
                return new ItemStack(Material.CARROT, ((Random)random).nextInt(3) + 1);
            }
            case BEETROOTS: {
                return new ItemStack(Material.BEETROOT, ((Random)random).nextInt(3) + 1);
            }
            case COCOA: {
                return new ItemStack(Material.COCOA_BEANS, ((Random)random).nextInt(3) + 1);
            }
            case NETHER_WART: {
                return new ItemStack(Material.NETHER_WART, ((Random)random).nextInt(3) + 1);
            }
            case SWEET_BERRY_BUSH: {
                return new ItemStack(Material.SWEET_BERRIES, ((Random)random).nextInt(3) + 1);
            }
        }
        return null;
    }
}

