/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.settings.DoubleRangeSetting;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class SolarHelmet
extends SlimefunItem {
    private final ItemSetting<Double> charge;

    @ParametersAreNonnullByDefault
    public SolarHelmet(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, double defaultChargingLevel) {
        super(category, item, recipeType, recipe);
        if (defaultChargingLevel <= 0.0) {
            throw new IllegalArgumentException("A Solar Helmet must have a positive charging level!");
        }
        this.charge = new DoubleRangeSetting(this, "charge-amount", 0.01, defaultChargingLevel, Double.MAX_VALUE);
        this.addItemSetting(this.charge);
    }

    public void rechargeItems(@Nonnull Player p) {
        PlayerInventory inv = p.getInventory();
        this.recharge(inv.getChestplate());
        this.recharge(inv.getLeggings());
        this.recharge(inv.getBoots());
        this.recharge(inv.getItemInMainHand());
        this.recharge(inv.getItemInOffHand());
    }

    private void recharge(@Nullable ItemStack item) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem instanceof Rechargeable) {
            ((Rechargeable)((Object)sfItem)).addItemCharge(item, this.charge.getValue().floatValue());
        }
    }
}

