/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.protection.modules;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.Set;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionModule;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class WorldGuardProtectionModule
implements ProtectionModule {
    private WorldGuardPlugin worldguard;
    private WorldGuardPlatform platform;
    private RegionContainer container;
    private final Plugin plugin;

    public WorldGuardProtectionModule(@NonNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.worldguard = WorldGuardPlugin.inst();
        this.platform = WorldGuard.getInstance().getPlatform();
        this.container = this.platform.getRegionContainer();
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, ProtectableAction action) {
        com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)l);
        World world = BukkitAdapter.adapt((org.bukkit.World)l.getWorld());
        LocalPlayer player = this.worldguard.wrapOfflinePlayer(p);
        if (!action.isBlockAction()) {
            Set regions = this.container.get(world).getApplicableRegions(BlockVector3.at((double)l.getX(), (double)l.getY(), (double)l.getZ())).getRegions();
            if (regions.isEmpty()) {
                return true;
            }
            return this.container.createQuery().testState(loc, player, new StateFlag[]{this.convert(action)});
        }
        return this.container.createQuery().testBuild(loc, player, new StateFlag[]{this.convert(action)});
    }

    private StateFlag convert(ProtectableAction action) {
        switch (action) {
            case ATTACK_PLAYER: {
                return Flags.PVP;
            }
            case ATTACK_ENTITY: {
                return Flags.DAMAGE_ANIMALS;
            }
            case INTERACT_BLOCK: 
            case INTERACT_ENTITY: {
                return Flags.USE;
            }
            case BREAK_BLOCK: {
                return Flags.BLOCK_BREAK;
            }
            case PLACE_BLOCK: {
                return Flags.BLOCK_PLACE;
            }
        }
        return Flags.BUILD;
    }
}

