/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.Streamable;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.WeightedNode;

public class RandomizedSet<T>
implements Iterable<T>,
Streamable<T> {
    private final Set<WeightedNode<T>> internalSet;
    private int size = 0;
    private float totalWeights = 0.0f;

    public RandomizedSet() {
        this(LinkedHashSet::new);
    }

    public RandomizedSet(@NonNull Supplier<Set<WeightedNode<T>>> constructor) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        this.internalSet = constructor.get();
    }

    public RandomizedSet(@NonNull Collection<T> collection) {
        this();
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        for (T element : collection) {
            this.add(element, 1.0f);
        }
    }

    public int size() {
        return this.size;
    }

    public float sumWeights() {
        return this.totalWeights;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(@NonNull T obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        for (WeightedNode<T> node : this.internalSet) {
            if (!node.equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<WeightedNode<T>> iterator;
            {
                this.iterator = RandomizedSet.this.internalSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                WeightedNode node = this.iterator.next();
                return node == null ? null : (Object)node.getObject();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    public T[] toArray(@NonNull IntFunction<T[]> constructor) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        T[] array = constructor.apply(this.size);
        Iterator<T> iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            array[i] = iterator.next();
            ++i;
        }
        return array;
    }

    public boolean add(@NonNull T obj, float weight) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (weight <= 0.0f) {
            throw new IllegalArgumentException("A Weight may never be less than or equal to zero!");
        }
        if (this.internalSet.add(new WeightedNode<T>(weight, obj))) {
            ++this.size;
            this.totalWeights += weight;
            return true;
        }
        return false;
    }

    public void setWeight(@NonNull T obj, float weight) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (weight <= 0.0f) {
            throw new IllegalArgumentException("A Weight may never be less than or equal to zero!");
        }
        for (WeightedNode<T> node : this.internalSet) {
            if (!node.equals(obj)) continue;
            --this.size;
            this.totalWeights -= node.getWeight();
            this.totalWeights += weight;
            node.setWeight(weight);
            return;
        }
        throw new IllegalStateException("The specified Object is not contained in this Set");
    }

    public boolean remove(@NonNull T obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Iterator<WeightedNode<T>> iterator = this.internalSet.iterator();
        while (iterator.hasNext()) {
            WeightedNode<T> node = iterator.next();
            if (!node.equals(obj)) continue;
            --this.size;
            this.totalWeights -= node.getWeight();
            iterator.remove();
            return true;
        }
        return false;
    }

    public void clear() {
        this.size = 0;
        this.totalWeights = 0.0f;
        this.internalSet.clear();
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public T getRandom() {
        return this.getRandom(ThreadLocalRandom.current());
    }

    public T getRandom(@NonNull Random random) {
        if (random == null) {
            throw new NullPointerException("random is marked non-null but is null");
        }
        float goal = random.nextFloat() * this.totalWeights;
        float i = 0.0f;
        Iterator<WeightedNode<T>> iterator = this.internalSet.iterator();
        WeightedNode<T> node = null;
        while (iterator.hasNext()) {
            node = iterator.next();
            if (!((i += node.getWeight()) >= goal)) continue;
            return node.getObject();
        }
        return node == null ? null : (T)node.getObject();
    }

    public Set<T> getRandomSubset(int size) {
        return this.getRandomSubset(ThreadLocalRandom.current(), size);
    }

    public Set<T> getRandomSubset(@NonNull Random random, int size) {
        if (random == null) {
            throw new NullPointerException("random is marked non-null but is null");
        }
        if (size > this.size()) {
            throw new IllegalArgumentException("A random Subset may not be larger than the original Set! (" + size + " > " + this.size() + ")");
        }
        if (size == this.size()) {
            return this.internalSet.stream().map(WeightedNode::getObject).collect(Collectors.toSet());
        }
        HashSet<T> subset = new HashSet<T>();
        while (subset.size() < size) {
            subset.add(this.getRandom(random));
        }
        return subset;
    }

    public Map<T, Float> toMap() {
        HashMap<T, Float> map = new HashMap<T, Float>();
        for (WeightedNode<T> node : this.internalSet) {
            map.put(node.getObject(), Float.valueOf(node.getWeight() / this.totalWeights));
        }
        return map;
    }

    public Stream<T> randomInfiniteStream() {
        return Stream.generate(this::getRandom);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (WeightedNode<T> node : this.internalSet) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append("(").append(node.getObject().toString()).append(" | " + node.getWeight() + ")");
        }
        return this.getClass().getSimpleName() + "{" + builder.toString() + "}";
    }
}

