/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.BaseResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.GenericType;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.ObjectMapper;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.RawResponse;
import java.util.Optional;
import java.util.function.Function;

class ObjectResponse<T>
extends BaseResponse<T> {
    private final T body;
    private final ObjectMapper om;
    private String rawBody;

    ObjectResponse(ObjectMapper om, RawResponse response, Class<? extends T> to) {
        super(response);
        this.om = om;
        this.body = this.readBody(response).map((? super T s) -> this.getBody((String)s, e -> om.readValue((String)e, to))).orElse(null);
    }

    ObjectResponse(ObjectMapper om, RawResponse response, GenericType<? extends T> to) {
        super(response);
        this.om = om;
        this.body = this.readBody(response).map((? super T s) -> this.getBody((String)s, e -> om.readValue((String)e, to))).orElse(null);
    }

    private Optional<String> readBody(RawResponse response) {
        if (!response.hasContent()) {
            return Optional.empty();
        }
        String s = response.getContentAsString();
        if (response.getStatus() >= 400) {
            this.rawBody = s;
        }
        return Optional.of(s);
    }

    private T getBody(String b, Function<String, T> func) {
        try {
            return func.apply(b);
        }
        catch (RuntimeException e) {
            this.setParsingException(b, e);
            return null;
        }
    }

    @Override
    public T getBody() {
        return this.body;
    }

    @Override
    protected String getRawBody() {
        return this.rawBody;
    }
}

