/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSpawnReason;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.EntityInteractHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.settings.GoldPanDrop;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.RandomizedSet;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;

public class GoldPan
extends SimpleSlimefunItem<ItemUseHandler>
implements RecipeDisplayItem {
    private final RandomizedSet<ItemStack> randomizer = new RandomizedSet();
    private final Set<GoldPanDrop> drops = new HashSet<GoldPanDrop>();

    @ParametersAreNonnullByDefault
    public GoldPan(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.drops.addAll(this.getGoldPanDrops());
        this.addItemSetting(this.drops.toArray(new GoldPanDrop[0]));
        this.addItemHandler(this.onEntityInteract());
    }

    @Nonnull
    public Material getInputMaterial() {
        return Material.GRAVEL;
    }

    @Nonnull
    protected Set<GoldPanDrop> getGoldPanDrops() {
        HashSet<GoldPanDrop> settings = new HashSet<GoldPanDrop>();
        settings.add(new GoldPanDrop(this, "chance.FLINT", 40, new ItemStack(Material.FLINT)));
        settings.add(new GoldPanDrop(this, "chance.CLAY", 20, new ItemStack(Material.CLAY_BALL)));
        settings.add(new GoldPanDrop(this, "chance.SIFTED_ORE", 35, SlimefunItems.SIFTED_ORE));
        settings.add(new GoldPanDrop(this, "chance.IRON_NUGGET", 5, new ItemStack(Material.IRON_NUGGET)));
        return settings;
    }

    @Override
    public void postRegister() {
        super.postRegister();
        this.updateRandomizer();
    }

    public void updateRandomizer() {
        this.randomizer.clear();
        for (GoldPanDrop setting : this.drops) {
            if ((Integer)setting.getValue() <= 0) continue;
            this.randomizer.add(setting.getOutput(), ((Integer)setting.getValue()).intValue());
        }
    }

    @Nonnull
    public ItemStack getRandomOutput() {
        ItemStack item = this.randomizer.getRandom();
        return item != null ? item : new ItemStack(Material.AIR);
    }

    @Override
    @Nonnull
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.gold-pan";
    }

    @Override
    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            Block b;
            Optional<Block> block = e.getClickedBlock();
            if (block.isPresent() && (b = block.get()).getType() == this.getInputMaterial() && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b.getLocation(), ProtectableAction.BREAK_BLOCK)) {
                ItemStack output = this.getRandomOutput();
                b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
                b.setType(Material.AIR);
                if (output.getType() != Material.AIR) {
                    SlimefunUtils.spawnItem(b.getLocation(), output.clone(), ItemSpawnReason.GOLD_PAN_USE, true);
                }
            }
            e.cancel();
        };
    }

    @Nonnull
    public EntityInteractHandler onEntityInteract() {
        return (e, item, offHand) -> {
            if (!(e.getRightClicked() instanceof ItemFrame)) {
                e.setCancelled(true);
            }
        };
    }

    @Override
    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        LinkedList<ItemStack> recipes = new LinkedList<ItemStack>();
        for (GoldPanDrop drop : this.drops) {
            if ((Integer)drop.getValue() <= 0) continue;
            recipes.add(new ItemStack(this.getInputMaterial()));
            recipes.add(drop.getOutput());
        }
        return recipes;
    }
}

