/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.api.events.AndroidMineEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidInstance;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ProgrammableAndroid;
import io.github.thebusybiscuit.slimefun4.utils.InfiniteBlockGenerator;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class MinerAndroid
extends ProgrammableAndroid {
    private final ItemStack effectivePickaxe = new ItemStack(Material.DIAMOND_PICKAXE);
    private final ItemSetting<Boolean> firesEvent = new ItemSetting<Boolean>(this, "trigger-event-for-generators", false);
    private final ItemSetting<Boolean> applyOptimizations = new ItemSetting<Boolean>(this, "reduced-block-updates", true);

    @ParametersAreNonnullByDefault
    public MinerAndroid(Category category, int tier, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, tier, item, recipeType, recipe);
        this.addItemSetting(this.firesEvent, this.applyOptimizations);
    }

    @Override
    @Nonnull
    public AndroidType getAndroidType() {
        return AndroidType.MINER;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void dig(Block b, BlockMenu menu, Block block) {
        Collection drops = block.getDrops(this.effectivePickaxe);
        if (!SlimefunTag.UNBREAKABLE_MATERIALS.isTagged(block.getType()) && !drops.isEmpty()) {
            OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo(b.getLocation(), "owner")));
            if (SlimefunPlugin.getProtectionManager().hasPermission(owner, block.getLocation(), ProtectableAction.BREAK_BLOCK)) {
                AndroidMineEvent event = new AndroidMineEvent(block, new AndroidInstance(this, b));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                if (!BlockStorage.hasBlockInfo(block)) {
                    block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
                    this.breakBlock(menu, drops, block);
                }
            }
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void moveAndDig(Block b, BlockMenu menu, BlockFace face, Block block) {
        Collection drops = block.getDrops(this.effectivePickaxe);
        if (!SlimefunTag.UNBREAKABLE_MATERIALS.isTagged(block.getType()) && !drops.isEmpty()) {
            OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo(b.getLocation(), "owner")));
            if (SlimefunPlugin.getProtectionManager().hasPermission(owner, block.getLocation(), ProtectableAction.BREAK_BLOCK)) {
                AndroidMineEvent event = new AndroidMineEvent(block, new AndroidInstance(this, b));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                if (!BlockStorage.hasBlockInfo(block)) {
                    block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
                    this.breakBlock(menu, drops, block);
                    this.move(b, face, block);
                }
            } else {
                this.move(b, face, block);
            }
        } else {
            this.move(b, face, block);
        }
    }

    @ParametersAreNonnullByDefault
    private void breakBlock(BlockMenu menu, Collection<ItemStack> drops, Block block) {
        for (ItemStack drop : drops) {
            menu.pushItem(drop, this.getOutputSlots());
        }
        if (this.applyOptimizations.getValue().booleanValue()) {
            InfiniteBlockGenerator generator = InfiniteBlockGenerator.findAt(block);
            if (generator != null) {
                if (this.firesEvent.getValue().booleanValue()) {
                    generator.callEvent(block);
                }
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 0.075f, 0.8f);
                block.getWorld().spawnParticle(Particle.SMOKE_NORMAL, (double)block.getX() + 0.5, (double)block.getY() + 1.25, (double)block.getZ() + 0.5, 8, 0.5, 0.5, 0.5, 0.015);
            } else {
                block.setType(Material.AIR);
            }
        } else {
            block.setType(Material.AIR);
        }
    }
}

