/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.reactors;

import io.github.thebusybiscuit.slimefun4.api.events.ReactorExplodeEvent;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.cargo.ReactorAccessPort;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.AbstractEnergyProvider;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.reactors.ReactorMode;
import io.github.thebusybiscuit.slimefun4.implementation.operations.FuelOperation;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public abstract class Reactor
extends AbstractEnergyProvider
implements HologramOwner,
MachineProcessHolder<FuelOperation> {
    private static final String MODE = "reactor-mode";
    private static final int INFO_SLOT = 49;
    private static final int COOLANT_DURATION = 50;
    private static final BlockFace[] WATER_BLOCKS = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private static final int[] border = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 12, 13, 14, 21, 23};
    private static final int[] border_1 = new int[]{9, 10, 11, 18, 20, 27, 29, 36, 38, 45, 46, 47};
    private static final int[] border_2 = new int[]{15, 16, 17, 24, 26, 33, 35, 42, 44, 51, 52, 53};
    private static final int[] border_3 = new int[]{30, 31, 32, 39, 41, 48, 50};
    private static final int[] border_4 = new int[]{25, 34, 43};
    private final Set<Location> explosionsQueue = new HashSet<Location>();
    private final MachineProcessor<FuelOperation> processor = new MachineProcessor<FuelOperation>(this);

    @ParametersAreNonnullByDefault
    protected Reactor(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.processor.setProgressBar(this.getProgressBar());
        new BlockMenuPreset(this.getId(), this.getInventoryTitle()){

            @Override
            public void init() {
                Reactor.this.constructMenu(this);
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
                if (BlockStorage.getLocationInfo(b.getLocation(), Reactor.MODE) == null) {
                    BlockStorage.addBlockInfo(b, Reactor.MODE, ReactorMode.GENERATOR.toString());
                }
                Reactor.this.updateInventory(menu, b);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.INTERACT_BLOCK);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }
        };
        this.addItemHandler(this.onBreak());
        this.registerDefaultFuelTypes();
    }

    @Override
    public MachineProcessor<FuelOperation> getMachineProcessor() {
        return this.processor;
    }

    @Nonnull
    private BlockBreakHandler onBreak() {
        return new SimpleBlockBreakHandler(){

            @Override
            public void onBlockBreak(@Nonnull Block b) {
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), Reactor.this.getFuelSlots());
                    inv.dropItems(b.getLocation(), Reactor.this.getCoolantSlots());
                    inv.dropItems(b.getLocation(), Reactor.this.getOutputSlots());
                }
                Reactor.this.processor.endOperation(b);
                Reactor.this.removeHologram(b);
            }
        };
    }

    protected void updateInventory(@Nonnull BlockMenu menu, @Nonnull Block b) {
        ReactorMode mode = this.getReactorMode(b.getLocation());
        switch (mode) {
            case GENERATOR: {
                menu.replaceExistingItem(4, new CustomItem((ItemStack)SlimefunItems.NUCLEAR_REACTOR, "&7Focus: &eElectricity", "", "&6Your Reactor will focus on Power Generation", "&6If your Energy Network doesn't need Power", "&6it will not produce any either", "", "&7\u21e8 Click to change the Focus to &eProduction"));
                menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                    BlockStorage.addBlockInfo(b, MODE, ReactorMode.PRODUCTION.toString());
                    this.updateInventory(menu, b);
                    return false;
                });
                break;
            }
            case PRODUCTION: {
                menu.replaceExistingItem(4, new CustomItem((ItemStack)SlimefunItems.PLUTONIUM, "&7Focus: &eProduction", "", "&6Your Reactor will focus on producing goods", "&6If your Energy Network doesn't need Power", "&6it will continue to run and simply will", "&6not generate any Power in the mean time", "", "&7\u21e8 Click to change the Focus to &ePower Generation"));
                menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                    BlockStorage.addBlockInfo(b, MODE, ReactorMode.GENERATOR.toString());
                    this.updateInventory(menu, b);
                    return false;
                });
                break;
            }
        }
        BlockMenu port = this.getAccessPort(b.getLocation());
        if (port != null) {
            menu.replaceExistingItem(49, new CustomItem(Material.GREEN_WOOL, "&7Access Port", "", "&6Detected", "", "&7> Click to view Access Port"));
            menu.addMenuClickHandler(49, (p, slot, item, action) -> {
                port.open(p);
                this.updateInventory(menu, b);
                return false;
            });
        } else {
            menu.replaceExistingItem(49, new CustomItem(Material.RED_WOOL, "&7Access Port", "", "&cNot detected", "", "&7Access Port must be", "&7placed 3 blocks above", "&7a reactor!"));
            menu.addMenuClickHandler(49, (p, slot, item, action) -> {
                this.updateInventory(menu, b);
                menu.open(p);
                return false;
            });
        }
    }

    private void constructMenu(@Nonnull BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_1) {
            preset.addItem(i, new CustomItem(Material.LIME_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_3) {
            preset.addItem(i, new CustomItem(Material.GREEN_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(22, new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(1, new CustomItem(this.getFuelIcon(), "&7Fuel Slot", "", "&fThis Slot accepts radioactive Fuel such as:", "&2Uranium &for &aNeptunium"), ChestMenuUtils.getEmptyClickHandler());
        for (int i : border_2) {
            preset.addItem(i, new CustomItem(Material.CYAN_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        if (this.needsCooling()) {
            preset.addItem(7, new CustomItem(this.getCoolant(), "&bCoolant Slot", "", "&fThis Slot accepts Coolant Cells", "&4Without any Coolant Cells, your Reactor", "&4will explode"));
        } else {
            preset.addItem(7, new CustomItem(Material.BARRIER, "&bCoolant Slot", "", "&fThis Slot accepts Coolant Cells"));
            for (int i : border_4) {
                preset.addItem(i, new CustomItem(Material.BARRIER, "&cNo Coolant Required", new String[0]), ChestMenuUtils.getEmptyClickHandler());
            }
        }
    }

    @Nonnull
    protected ReactorMode getReactorMode(@Nonnull Location l) {
        ReactorMode mode = ReactorMode.GENERATOR;
        if (BlockStorage.hasBlockInfo(l) && BlockStorage.getLocationInfo(l, MODE).equals(ReactorMode.PRODUCTION.toString())) {
            mode = ReactorMode.PRODUCTION;
        }
        return mode;
    }

    public abstract void extraTick(@Nonnull Location var1);

    @Nullable
    public abstract ItemStack getCoolant();

    @Nonnull
    public abstract ItemStack getFuelIcon();

    protected final boolean needsCooling() {
        return this.getCoolant() != null;
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{19, 28, 37, 25, 34, 43};
    }

    public int[] getFuelSlots() {
        return new int[]{19, 28, 37};
    }

    @Nonnull
    public int[] getCoolantSlots() {
        int[] nArray;
        if (this.needsCooling()) {
            int[] nArray2 = new int[3];
            nArray2[0] = 25;
            nArray2[1] = 34;
            nArray = nArray2;
            nArray2[2] = 43;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{40};
    }

    @Override
    public int getGeneratedOutput(Location l, Config data) {
        BlockMenu inv = BlockStorage.getInventory(l);
        BlockMenu accessPort = this.getAccessPort(l);
        FuelOperation operation = this.processor.getOperation(l);
        if (operation != null) {
            this.extraTick(l);
            if (!operation.isFinished()) {
                return this.generateEnergy(l, data, inv, accessPort, operation);
            }
            this.createByproduct(l, inv, accessPort, operation);
            return 0;
        }
        this.burnNextFuel(l, inv, accessPort);
        return 0;
    }

    private int generateEnergy(@Nonnull Location l, @Nonnull Config data, @Nonnull BlockMenu inv, @Nullable BlockMenu accessPort, @Nonnull FuelOperation operation) {
        int space;
        int produced = this.getEnergyProduction();
        String energyData = data.getString("energy-charge");
        int charge = 0;
        if (energyData != null) {
            charge = Integer.parseInt(energyData);
        }
        if ((space = this.getCapacity() - charge) >= produced || this.getReactorMode(l) != ReactorMode.GENERATOR) {
            operation.addProgress(1);
            this.checkForWaterBlocks(l);
            this.processor.updateProgressBar(inv, 22, operation);
            if (this.needsCooling() && !this.hasEnoughCoolant(l, inv, accessPort, operation)) {
                this.explosionsQueue.add(l);
                return 0;
            }
        }
        if (space >= produced) {
            return this.getEnergyProduction();
        }
        return 0;
    }

    @Override
    public boolean willExplode(Location l, Config data) {
        boolean explosion = this.explosionsQueue.contains(l);
        if (explosion) {
            SlimefunPlugin.runSync(() -> {
                ReactorExplodeEvent event = new ReactorExplodeEvent(l, this);
                Bukkit.getPluginManager().callEvent((Event)event);
                BlockStorage.getInventory(l).close();
                this.removeHologram(l.getBlock());
            });
            this.explosionsQueue.remove(l);
            this.processor.endOperation(l);
        }
        return explosion;
    }

    private void checkForWaterBlocks(Location l) {
        SlimefunPlugin.runSync(() -> {
            int index = ThreadLocalRandom.current().nextInt(WATER_BLOCKS.length);
            BlockFace randomNeighbour = WATER_BLOCKS[index];
            if (l.getBlock().getRelative(randomNeighbour).getType() != Material.WATER) {
                this.explosionsQueue.add(l);
            }
        });
    }

    private void createByproduct(@Nonnull Location l, @Nonnull BlockMenu inv, @Nullable BlockMenu accessPort, @Nonnull FuelOperation operation) {
        inv.replaceExistingItem(22, new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
        ItemStack result = operation.getResult();
        if (result != null) {
            inv.pushItem(result.clone(), this.getOutputSlots());
        }
        if (accessPort != null) {
            for (int slot : this.getOutputSlots()) {
                if (inv.getItemInSlot(slot) == null) continue;
                inv.replaceExistingItem(slot, accessPort.pushItem(inv.getItemInSlot(slot), ReactorAccessPort.getOutputSlots()));
            }
        }
        this.processor.endOperation(l);
    }

    private void burnNextFuel(Location l, BlockMenu inv, BlockMenu accessPort) {
        HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
        MachineFuel fuel = this.findFuel(inv, found);
        if (accessPort != null) {
            this.restockFuel(inv, accessPort);
        }
        if (fuel != null) {
            for (Map.Entry entry : found.entrySet()) {
                inv.consumeItem((Integer)entry.getKey(), (Integer)entry.getValue());
            }
            this.processor.startOperation(l, new FuelOperation(fuel));
        }
    }

    private boolean hasEnoughCoolant(@Nonnull Location reactor, @Nonnull BlockMenu menu, @Nullable BlockMenu accessPort, @Nonnull FuelOperation operation) {
        boolean requiresCoolant;
        boolean bl = requiresCoolant = operation.getProgress() % 50 == 0;
        if (requiresCoolant) {
            ItemStackWrapper coolant = ItemStackWrapper.wrap(this.getCoolant());
            if (accessPort != null) {
                for (int slot : this.getCoolantSlots()) {
                    if (!SlimefunUtils.isItemSimilar(accessPort.getItemInSlot(slot), coolant, true, false)) continue;
                    ItemStack remainingItem = menu.pushItem(accessPort.getItemInSlot(slot), this.getCoolantSlots());
                    accessPort.replaceExistingItem(slot, remainingItem);
                }
            }
            for (int slot : this.getCoolantSlots()) {
                if (!SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), coolant, true, false)) continue;
                menu.consumeItem(slot);
                this.updateHologram(reactor.getBlock(), "&b\u2744 &7100%");
                return true;
            }
            return false;
        }
        this.updateHologram(reactor.getBlock(), "&b\u2744 &7" + this.getPercentage(operation.getRemainingTicks(), operation.getTotalTicks()) + "%");
        return true;
    }

    private float getPercentage(int time, int total) {
        int passed = (total - time) % 50;
        return Math.round((float)(50 - passed) * 100.0f / 50.0f * 100.0f / 100.0f);
    }

    @ParametersAreNonnullByDefault
    private void restockFuel(BlockMenu menu, BlockMenu port) {
        for (int slot : this.getFuelSlots()) {
            for (MachineFuel fuelType : this.fuelTypes) {
                if (!fuelType.test(port.getItemInSlot(slot)) || !menu.fits(new CustomItem(port.getItemInSlot(slot), 1), this.getFuelSlots())) continue;
                port.replaceExistingItem(slot, menu.pushItem(port.getItemInSlot(slot), this.getFuelSlots()));
                return;
            }
        }
    }

    @Nullable
    @ParametersAreNonnullByDefault
    private MachineFuel findFuel(BlockMenu menu, Map<Integer, Integer> found) {
        for (MachineFuel fuel : this.fuelTypes) {
            for (int slot : this.getInputSlots()) {
                if (!fuel.test(menu.getItemInSlot(slot))) continue;
                found.put(slot, fuel.getInput().getAmount());
                return fuel;
            }
        }
        return null;
    }

    @Nullable
    protected BlockMenu getAccessPort(@Nonnull Location l) {
        Location port = new Location(l.getWorld(), l.getX(), l.getY() + 3.0, l.getZ());
        if (BlockStorage.check(port, SlimefunItems.REACTOR_ACCESS_PORT.getItemId())) {
            return BlockStorage.getInventory(port);
        }
        return null;
    }
}

