/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.inventory;

import java.util.HashMap;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.MenuClickHandler;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class InvUtils {
    public static final MenuClickHandler EMPTY_CLICK = (p, slot, item, cursor, action) -> false;

    private InvUtils() {
    }

    public static boolean hasEmptySlot(@NonNull Inventory inv) {
        if (inv == null) {
            throw new NullPointerException("inv is marked non-null but is null");
        }
        return inv.firstEmpty() != 1;
    }

    public static boolean isEmpty(@NonNull Inventory inv) {
        if (inv == null) {
            throw new NullPointerException("inv is marked non-null but is null");
        }
        for (ItemStack item : inv) {
            if (item == null || item.getType().isAir()) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidStackSize(@NonNull ItemStack stack, @NonNull ItemStack item, @NonNull Inventory inv) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (inv == null) {
            throw new NullPointerException("inv is marked non-null but is null");
        }
        int newStackSize = stack.getAmount() + item.getAmount();
        return newStackSize <= stack.getMaxStackSize() && newStackSize <= inv.getMaxStackSize();
    }

    public static boolean isItemAllowed(@NonNull Material itemType, @NonNull InventoryType inventoryType) {
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        if (inventoryType == null) {
            throw new NullPointerException("inventoryType is marked non-null but is null");
        }
        switch (inventoryType) {
            case LECTERN: {
                return itemType == Material.WRITABLE_BOOK || itemType == Material.WRITTEN_BOOK;
            }
            case SHULKER_BOX: {
                return itemType != Material.SHULKER_BOX && !itemType.name().endsWith("_SHULKER_BOX");
            }
        }
        return true;
    }

    public static boolean fits(@NonNull Inventory inv, @NonNull ItemStack item, int ... slots) {
        if (inv == null) {
            throw new NullPointerException("inv is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (!InvUtils.isItemAllowed(item.getType(), inv.getType())) {
            return false;
        }
        if (slots.length == 0) {
            slots = IntStream.range(0, inv.getSize()).toArray();
        }
        for (int slot : slots) {
            ItemStack stack = inv.getItem(slot);
            if (stack == null || stack.getType() == Material.AIR) {
                return true;
            }
            if (!InvUtils.isValidStackSize(stack, item, inv) || !ItemUtils.canStack(stack, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean fitAll(@NonNull Inventory inv, @NonNull ItemStack[] items, int ... slots) {
        if (inv == null) {
            throw new NullPointerException("inv is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (slots.length == 0) {
            slots = IntStream.range(0, inv.getSize()).toArray();
        }
        if (items.length == 0) {
            return true;
        }
        if (items.length == 1) {
            return InvUtils.fits(inv, items[0], slots);
        }
        HashMap<Integer, ItemStack> cache = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            boolean resolved = false;
            for (int slot : slots) {
                ItemStack stack = cache.getOrDefault(slot, inv.getItem(slot));
                if (stack == null || stack.getType() == Material.AIR) {
                    cache.put(slot, items[i]);
                    resolved = true;
                } else if (InvUtils.isValidStackSize(stack, item, inv) && ItemUtils.canStack(stack, item)) {
                    ItemStack clone = stack.clone();
                    clone.setAmount(stack.getAmount() + item.getAmount());
                    cache.put(slot, clone);
                    resolved = true;
                }
                if (resolved) break;
            }
            if (resolved) continue;
            return false;
        }
        return true;
    }

    public static boolean removeItem(@NonNull Inventory inv, int amount, boolean replaceConsumables, @NonNull Predicate<ItemStack> predicate) {
        if (inv == null) {
            throw new NullPointerException("inv is marked non-null but is null");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        int removed = 0;
        for (int slot = 0; slot < inv.getSize(); ++slot) {
            ItemStack item = inv.getItem(slot);
            if (item == null || !predicate.test(item)) continue;
            if (item.getAmount() + removed >= amount) {
                ItemUtils.consumeItem(item, amount - removed, replaceConsumables);
                return true;
            }
            if (item.getAmount() <= 0) continue;
            removed += item.getAmount();
            ItemUtils.consumeItem(item, item.getAmount(), replaceConsumables);
        }
        return false;
    }
}

