/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.operations;

import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;

public class CraftingOperation
implements MachineOperation {
    private final ItemStack[] ingredients;
    private final ItemStack[] results;
    private final int totalTicks;
    private int currentTicks = 0;

    public CraftingOperation(@Nonnull MachineRecipe recipe) {
        this(recipe.getInput(), recipe.getOutput(), recipe.getTicks());
    }

    public CraftingOperation(@Nonnull ItemStack[] ingredients, @Nonnull ItemStack[] results, int totalTicks) {
        Validate.notEmpty((Object[])ingredients, (String)"The Ingredients array cannot be empty or null");
        Validate.notEmpty((Object[])results, (String)"The results array cannot be empty or null");
        Validate.isTrue((totalTicks >= 0 ? 1 : 0) != 0, (String)("The amount of total ticks must be a positive integer or zero, received: " + totalTicks));
        this.ingredients = ingredients;
        this.results = results;
        this.totalTicks = totalTicks;
    }

    @Override
    public void addProgress(int num) {
        Validate.isTrue((num > 0 ? 1 : 0) != 0, (String)"Progress must be positive.");
        this.currentTicks += num;
    }

    @Nonnull
    public ItemStack[] getIngredients() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack[] getResults() {
        return this.results;
    }

    @Override
    public int getProgress() {
        return this.currentTicks;
    }

    @Override
    public int getTotalTicks() {
        return this.totalTicks;
    }
}

