/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.scheduling;

import java.util.function.IntConsumer;
import lombok.NonNull;

class TaskNode {
    private final IntConsumer runnable;
    private final boolean asynchronous;
    private int delay = 0;
    private TaskNode nextNode;

    protected TaskNode(@NonNull IntConsumer consumer, boolean async) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        this.runnable = consumer;
        this.asynchronous = async;
    }

    protected TaskNode(@NonNull IntConsumer consumer, int delay, boolean async) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        this.runnable = consumer;
        this.delay = delay;
        this.asynchronous = async;
    }

    protected boolean hasNextNode() {
        return this.nextNode != null;
    }

    public IntConsumer getRunnable() {
        return this.runnable;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public int getDelay() {
        return this.delay;
    }

    public TaskNode getNextNode() {
        return this.nextNode;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setNextNode(TaskNode nextNode) {
        this.nextNode = nextNode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskNode)) {
            return false;
        }
        TaskNode other = (TaskNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsynchronous() != other.isAsynchronous()) {
            return false;
        }
        if (this.getDelay() != other.getDelay()) {
            return false;
        }
        IntConsumer this$runnable = this.getRunnable();
        IntConsumer other$runnable = other.getRunnable();
        if (this$runnable == null ? other$runnable != null : !this$runnable.equals(other$runnable)) {
            return false;
        }
        TaskNode this$nextNode = this.getNextNode();
        TaskNode other$nextNode = other.getNextNode();
        return !(this$nextNode == null ? other$nextNode != null : !((Object)this$nextNode).equals(other$nextNode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsynchronous() ? 79 : 97);
        result = result * 59 + this.getDelay();
        IntConsumer $runnable = this.getRunnable();
        result = result * 59 + ($runnable == null ? 43 : $runnable.hashCode());
        TaskNode $nextNode = this.getNextNode();
        result = result * 59 + ($nextNode == null ? 43 : ((Object)$nextNode).hashCode());
        return result;
    }

    public String toString() {
        return "TaskNode(runnable=" + this.getRunnable() + ", asynchronous=" + this.isAsynchronous() + ", delay=" + this.getDelay() + ", nextNode=" + this.getNextNode() + ")";
    }
}

