/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Bukkit;

public final class ReflectionUtils {
    private static final int MAJOR_VERSION;
    private static final String CURRENT_VERSION;
    private static final Map<Class<?>, Class<?>> primitiveTypes;
    private static final Pattern versionPattern;

    private ReflectionUtils() {
    }

    @Nullable
    public static Method getMethod(@NonNull Class<?> c, @NonNull String method) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(method)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NonNull Class<?> c, @NonNull String method, Class<?> ... paramTypes) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        Class<?>[] t = ReflectionUtils.toPrimitiveTypeArray(paramTypes);
        for (Method m : c.getMethods()) {
            Class<?>[] types = ReflectionUtils.toPrimitiveTypeArray(m.getParameterTypes());
            if (!m.getName().equals(method) || !ReflectionUtils.equalsTypeArray(types, t)) continue;
            return m;
        }
        return null;
    }

    @Nonnull
    public static Field getField(@NonNull Class<?> c, @NonNull String field) throws NoSuchFieldException {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return c.getDeclaredField(field);
    }

    public static <T> void setFieldValue(@NonNull T object, @NonNull Class<?> c, @NonNull String field, @Nullable Object value) throws NoSuchFieldException, IllegalAccessException {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Field f = ReflectionUtils.getField(c, field);
        f.setAccessible(true);
        f.set(object, value);
    }

    public static <T> void setFieldValue(@NonNull T object, @NonNull String field, @Nullable Object value) throws NoSuchFieldException, IllegalAccessException {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Field f = ReflectionUtils.getField(object.getClass(), field);
        f.setAccessible(true);
        f.set(object, value);
    }

    @Nullable
    public static <T> T getFieldValue(@NonNull Object object, @NonNull Class<T> fieldType, @NonNull String field) throws NoSuchFieldException, IllegalAccessException {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (fieldType == null) {
            throw new NullPointerException("fieldType is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Field f = ReflectionUtils.getField(object.getClass(), field);
        f.setAccessible(true);
        return fieldType.cast(f.get(object));
    }

    @Nonnull
    public static Class<?>[] toPrimitiveTypeArray(@NonNull Class<?>[] classes) {
        if (classes == null) {
            throw new NullPointerException("classes is marked non-null but is null");
        }
        int size = classes.length;
        Class[] types = new Class[size];
        for (int i = 0; i < size; ++i) {
            Class<?> primitive = primitiveTypes.get(classes[i]);
            types[i] = primitive != null ? primitive : classes[i];
        }
        return types;
    }

    @Nonnull
    public static Class<?>[] toPrimitiveTypeArray(@NonNull Object[] objects) {
        if (objects == null) {
            throw new NullPointerException("objects is marked non-null but is null");
        }
        int size = objects.length;
        Class[] types = new Class[size];
        for (int i = 0; i < size; ++i) {
            Class<?> primitive = primitiveTypes.get(objects[i].getClass());
            types[i] = primitive != null ? primitive : objects[i].getClass();
        }
        return types;
    }

    @Nullable
    public static <T> Constructor<T> getConstructor(@NonNull Class<T> c, Class<?> ... paramTypes) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        Class<?>[] t = ReflectionUtils.toPrimitiveTypeArray(paramTypes);
        for (Constructor<?> constructor : c.getConstructors()) {
            Class<?>[] types = ReflectionUtils.toPrimitiveTypeArray(constructor.getParameterTypes());
            if (!ReflectionUtils.equalsTypeArray(types, t)) continue;
            return constructor;
        }
        return null;
    }

    @Nonnull
    public static Class<?> getInnerNMSClass(@NonNull String name, @NonNull String subname) throws ClassNotFoundException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (subname == null) {
            throw new NullPointerException("subname is marked non-null but is null");
        }
        return ReflectionUtils.getNMSClass(name + '$' + subname);
    }

    public static Class<?> getNetMinecraftClass(@Nonnull String name) throws ClassNotFoundException {
        return Class.forName("net.minecraft." + (MAJOR_VERSION <= 16 ? ReflectionUtils.getVersion() + '.' : "") + name);
    }

    @Nonnull
    public static Class<?> getNMSClass(@NonNull String name) throws ClassNotFoundException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Class.forName("net.minecraft.server." + (MAJOR_VERSION <= 16 ? ReflectionUtils.getVersion() + '.' : "") + name);
    }

    @Nonnull
    public static Class<?> getInnerOBCClass(@NonNull String name, @NonNull String subname) throws ClassNotFoundException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (subname == null) {
            throw new NullPointerException("subname is marked non-null but is null");
        }
        return ReflectionUtils.getOBCClass(name + '$' + subname);
    }

    @Nonnull
    public static Class<?> getOBCClass(@NonNull String name) throws ClassNotFoundException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Class.forName("org.bukkit.craftbukkit." + ReflectionUtils.getVersion() + '.' + name);
    }

    @Nonnull
    private static String getVersion() {
        return CURRENT_VERSION;
    }

    public static int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public static boolean isUnitTestEnvironment() {
        return ReflectionUtils.getVersion().equals("mockbukkit");
    }

    private static boolean equalsTypeArray(@NonNull Class<?>[] a, Class<?> ... o) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (a.length != o.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(o[i]) || a[i].isAssignableFrom(o[i])) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public static <T> List<T> getEnumConstants(@NonNull Class<T> c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        return Arrays.asList(c.getEnumConstants());
    }

    @Nullable
    public static <T> T getEnumConstant(@NonNull Class<T> c, @NonNull String name) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        for (T field : c.getEnumConstants()) {
            if (!field.toString().equals(name)) continue;
            return field;
        }
        return null;
    }

    static {
        primitiveTypes = new HashMap();
        versionPattern = Pattern.compile("v\\d_(\\d+)_R\\d");
        primitiveTypes.put(Byte.class, Byte.TYPE);
        primitiveTypes.put(Short.class, Short.TYPE);
        primitiveTypes.put(Integer.class, Integer.TYPE);
        primitiveTypes.put(Long.class, Long.TYPE);
        primitiveTypes.put(Character.class, Character.TYPE);
        primitiveTypes.put(Float.class, Float.TYPE);
        primitiveTypes.put(Double.class, Double.TYPE);
        primitiveTypes.put(Boolean.class, Boolean.TYPE);
        CURRENT_VERSION = Bukkit.getServer().getClass().getPackage().getName().substring(Bukkit.getServer().getClass().getPackage().getName().lastIndexOf(46) + 1);
        Matcher matcher = versionPattern.matcher(CURRENT_VERSION);
        MAJOR_VERSION = matcher.matches() ? Integer.parseInt(matcher.group(1)) : 0;
    }
}

