/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.collections;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import lombok.NonNull;

public final class CopyUtils {
    private CopyUtils() {
    }

    public static <T> void deepCopy(@NonNull Collection<T> source, @NonNull Function<T, T> cloningFunction, @NonNull Collection<T> sink) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (cloningFunction == null) {
            throw new NullPointerException("cloningFunction is marked non-null but is null");
        }
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        for (T original : source) {
            T cloned = cloningFunction.apply(original);
            sink.add(cloned);
        }
    }

    @NonNull
    public static <T, C extends Collection<T>> C deepCopy(@NonNull Collection<T> source, @NonNull Function<T, T> cloningFunction, @NonNull IntFunction<C> sinkSupplier) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (cloningFunction == null) {
            throw new NullPointerException("cloningFunction is marked non-null but is null");
        }
        if (sinkSupplier == null) {
            throw new NullPointerException("sinkSupplier is marked non-null but is null");
        }
        Collection sink = (Collection)sinkSupplier.apply(source.size());
        CopyUtils.deepCopy(source, cloningFunction, sink);
        return (C)sink;
    }

    public static <K, V> void deepCopy(@NonNull Map<K, V> source, @NonNull Function<V, V> cloningFunction, @NonNull Map<K, V> sink) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (cloningFunction == null) {
            throw new NullPointerException("cloningFunction is marked non-null but is null");
        }
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        for (Map.Entry<K, V> entry : source.entrySet()) {
            V original = entry.getValue();
            V cloned = cloningFunction.apply(original);
            sink.put(entry.getKey(), cloned);
        }
    }

    @NonNull
    public static <K, V, M extends Map<K, V>> M deepCopy(@NonNull Map<K, V> source, @NonNull Function<V, V> cloningFunction, @NonNull Supplier<M> sinkSupplier) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (cloningFunction == null) {
            throw new NullPointerException("cloningFunction is marked non-null but is null");
        }
        if (sinkSupplier == null) {
            throw new NullPointerException("sinkSupplier is marked non-null but is null");
        }
        Map sink = (Map)sinkSupplier.get();
        CopyUtils.deepCopy(source, cloningFunction, sink);
        return (M)sink;
    }

    public static <K, V> void deepCopy(@NonNull Map<K, V> source, @NonNull Function<V, V> cloningFunction) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (cloningFunction == null) {
            throw new NullPointerException("cloningFunction is marked non-null but is null");
        }
        for (Map.Entry<K, V> entry : source.entrySet()) {
            V original = entry.getValue();
            V cloned = cloningFunction.apply(original);
            entry.setValue(cloned);
        }
    }

    public static <T> void deepCopy(@NonNull T[] source, @NonNull Function<T, T> cloningFunction, @NonNull T[] sink) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (cloningFunction == null) {
            throw new NullPointerException("cloningFunction is marked non-null but is null");
        }
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (source.length > sink.length) {
            throw new IllegalArgumentException("Length of sink must be greater than or equal to that of the source!");
        }
        for (int i = 0; i < source.length; ++i) {
            sink[i] = cloningFunction.apply(source[i]);
        }
    }

    @NonNull
    public static <T> T[] deepCopy(@NonNull T[] source, @NonNull Function<T, T> cloningFunction, @NonNull IntFunction<T[]> sinkSupplier) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (cloningFunction == null) {
            throw new NullPointerException("cloningFunction is marked non-null but is null");
        }
        if (sinkSupplier == null) {
            throw new NullPointerException("sinkSupplier is marked non-null but is null");
        }
        T[] sink = sinkSupplier.apply(source.length);
        CopyUtils.deepCopy(source, cloningFunction, sink);
        return sink;
    }
}

