/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.skull;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.ReflectionUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.FakeGameProfile;
import org.bukkit.Material;
import org.bukkit.block.Block;

public final class SkullBlock {
    private static Constructor<?> newPosition;
    private static Method handle;
    private static Method getTileEntity;
    private static Method setGameProfile;

    private SkullBlock() {
    }

    public static void setFromHash(@NonNull Block block, @NonNull String hash) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        SkullBlock.setFromHash(block, hash, true);
    }

    public static void setFromHash(@NonNull Block block, @NonNull String hash, boolean causeBlockUpdate) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        SkullBlock.setFromHash(block, UUID.nameUUIDFromBytes(hash.getBytes(StandardCharsets.UTF_8)), hash, causeBlockUpdate);
    }

    public static void setFromHash(@NonNull Block block, @NonNull UUID uuid, @NonNull String hash) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        SkullBlock.setFromHash(block, uuid, hash, true);
    }

    public static void setFromHash(@NonNull Block block, @NonNull UUID uuid, @NonNull String hash, boolean causeBlockUpdate) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        SkullBlock.setFromURL(block, uuid, "http://textures.minecraft.net/texture/" + hash, causeBlockUpdate);
    }

    public static void setFromURL(@NonNull Block block, @NonNull String url) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        SkullBlock.setFromURL(block, url, true);
    }

    public static void setFromURL(@NonNull Block block, @NonNull String url, boolean causeBlockUpdate) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        SkullBlock.setFromURL(block, UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8)), url, causeBlockUpdate);
    }

    public static void setFromURL(@NonNull Block block, @NonNull UUID uuid, @NonNull String url) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        SkullBlock.setFromURL(block, uuid, url, true);
    }

    public static void setFromURL(@NonNull Block block, @NonNull UUID uuid, @NonNull String url, boolean causeBlockUpdate) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        SkullBlock.setFromBase64(block, uuid, Base64.getEncoder().encodeToString(("{\"textures\":{\"SKIN\":{\"url\":\"" + url + "\"}}}").getBytes(StandardCharsets.UTF_8)), causeBlockUpdate);
    }

    public static void setFromBase64(@NonNull Block block, @NonNull String texture) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        SkullBlock.setFromBase64(block, UUID.nameUUIDFromBytes(texture.getBytes(StandardCharsets.UTF_8)), texture);
    }

    public static void setFromBase64(@NonNull Block block, @NonNull UUID uuid, @NonNull String texture) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        SkullBlock.setFromBase64(block, uuid, texture, true);
    }

    public static void setFromBase64(@NonNull Block block, @NonNull UUID uuid, @NonNull String texture, boolean causeBlockUpdate) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        Material material = block.getType();
        if (material != Material.PLAYER_HEAD && material != Material.PLAYER_WALL_HEAD) {
            throw new IllegalArgumentException("Cannot update a head texture. Expected a Player Head, received: " + material);
        }
        try {
            FakeGameProfile profile = new FakeGameProfile(uuid, texture);
            Object world = handle.invoke((Object)block.getWorld(), new Object[0]);
            Object position = newPosition.newInstance(block.getX(), block.getY(), block.getZ());
            Object tileEntity = getTileEntity.invoke(world, position);
            if (tileEntity != null) {
                setGameProfile.invoke(tileEntity, new Object[]{profile});
                if (causeBlockUpdate) {
                    block.getState().update(true, false);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            if (ReflectionUtils.getMajorVersion() >= 17) {
                handle = ReflectionUtils.getOBCClass("CraftWorld").getMethod("getHandle", new Class[0]);
                setGameProfile = ReflectionUtils.getNetMinecraftClass("world.level.block.entity.TileEntitySkull").getMethod("setGameProfile", GameProfile.class);
                Class<?> blockPosition = ReflectionUtils.getNetMinecraftClass("core.BlockPosition");
                newPosition = ReflectionUtils.getConstructor(blockPosition, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                getTileEntity = ReflectionUtils.getNMSClass("level.WorldServer").getMethod("getTileEntity", blockPosition);
            } else {
                handle = ReflectionUtils.getOBCClass("CraftWorld").getMethod("getHandle", new Class[0]);
                setGameProfile = ReflectionUtils.getNMSClass("TileEntitySkull").getMethod("setGameProfile", GameProfile.class);
                Class<?> blockPosition = ReflectionUtils.getNMSClass("BlockPosition");
                newPosition = ReflectionUtils.getConstructor(blockPosition, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                getTileEntity = ReflectionUtils.getNMSClass("WorldServer").getMethod("getTileEntity", blockPosition);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            System.err.println("Perhaps you forgot to shade CS-CoreLib's \"reflection\" package?");
            e.printStackTrace();
        }
    }
}

