/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.geo;

import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class OilPump
extends AContainer
implements RecipeDisplayItem {
    private final GEOResource oil;
    private final ItemStack emptyBucket = new ItemStack(Material.BUCKET);

    @ParametersAreNonnullByDefault
    public OilPump(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.oil = SlimefunPlugin.getRegistry().getGEOResources().get(new NamespacedKey((Plugin)SlimefunPlugin.instance(), "oil")).orElse(null);
        new BlockMenuPreset(this.getId(), this.getInventoryTitle()){

            @Override
            public void init() {
                OilPump.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                if (!p.hasPermission("slimefun.inventory.bypass") && !SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.INTERACT_BLOCK)) {
                    return false;
                }
                if (!SlimefunPlugin.getGPSNetwork().getResourceManager().getSupplies(OilPump.this.oil, b.getWorld(), b.getX() >> 4, b.getZ() >> 4).isPresent()) {
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "gps.geo.scan-required", true);
                    return false;
                }
                return true;
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return OilPump.this.getInputSlots();
                }
                return OilPump.this.getOutputSlots();
            }
        };
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return Arrays.asList(new ItemStack[]{this.emptyBucket, SlimefunItems.OIL_BUCKET});
    }

    @Override
    public String getMachineIdentifier() {
        return "OIL_PUMP";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.DIAMOND_SHOVEL);
    }

    @Override
    protected MachineRecipe findNextRecipe(BlockMenu inv) {
        if (inv.fits(SlimefunItems.OIL_BUCKET, this.getOutputSlots())) {
            Block b = inv.getBlock();
            for (int slot : this.getInputSlots()) {
                if (!SlimefunUtils.isItemSimilar(inv.getItemInSlot(slot), this.emptyBucket, true, false)) continue;
                OptionalInt supplies = SlimefunPlugin.getGPSNetwork().getResourceManager().getSupplies(this.oil, b.getWorld(), b.getX() >> 4, b.getZ() >> 4);
                if (supplies.isPresent() && supplies.getAsInt() > 0) {
                    MachineRecipe recipe = new MachineRecipe(26, new ItemStack[]{this.emptyBucket}, new ItemStack[]{SlimefunItems.OIL_BUCKET});
                    inv.consumeItem(slot);
                    SlimefunPlugin.getGPSNetwork().getResourceManager().setSupplies(this.oil, b.getWorld(), b.getX() >> 4, b.getZ() >> 4, supplies.getAsInt() - 1);
                    return recipe;
                }
                ItemStack item = inv.getItemInSlot(slot).clone();
                inv.replaceExistingItem(slot, null);
                inv.pushItem(item, this.getOutputSlots());
                return null;
            }
        }
        return null;
    }
}

