/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.AbstractAutoCrafter;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets.Multimeter;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.GameRule;
import org.bukkit.Keyed;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public class AutoCrafterListener
implements Listener {
    @ParametersAreNonnullByDefault
    public AutoCrafterListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private boolean hasUnlockedRecipe(@Nonnull Player p, @Nonnull ItemStack item) {
        for (Recipe recipe : SlimefunPlugin.getMinecraftRecipeService().getRecipesFor(item)) {
            if (!(recipe instanceof Keyed) || p.hasDiscoveredRecipe(((Keyed)recipe).getKey())) continue;
            return false;
        }
        return true;
    }

    @EventHandler
    public void onInteract(PlayerRightClickEvent e) {
        Optional<Block> clickedBlock = e.getClickedBlock();
        if (e.getHand() == EquipmentSlot.HAND && e.useBlock() != Event.Result.DENY && clickedBlock.isPresent()) {
            Optional<SlimefunItem> slimefunBlock = e.getSlimefunBlock();
            if (!slimefunBlock.isPresent()) {
                return;
            }
            SlimefunItem block = slimefunBlock.get();
            if (block instanceof AbstractAutoCrafter) {
                Optional<SlimefunItem> slimefunItem = e.getSlimefunItem();
                if (!e.getPlayer().isSneaking() && slimefunItem.isPresent() && slimefunItem.get() instanceof Multimeter) {
                    return;
                }
                e.cancel();
                if (((Boolean)e.getPlayer().getWorld().getGameRuleValue(GameRule.DO_LIMITED_CRAFTING)).booleanValue() && !this.hasUnlockedRecipe(e.getPlayer(), e.getItem())) {
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)e.getPlayer(), "messages.auto-crafting.recipe-unavailable");
                    return;
                }
                AbstractAutoCrafter crafter = (AbstractAutoCrafter)block;
                try {
                    crafter.onRightClick(clickedBlock.get(), e.getPlayer());
                }
                catch (Exception | LinkageError x) {
                    crafter.error("Something went wrong while right-clicking an Auto-Crafter", x);
                }
            }
        }
    }
}

