/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.events;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class AsyncProfileLoadEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final UUID uniqueId;
    private PlayerProfile profile;

    public AsyncProfileLoadEvent(@Nonnull PlayerProfile profile) {
        super(true);
        Validate.notNull((Object)profile, (String)"The Profile cannot be null");
        this.uniqueId = profile.getUUID();
        this.profile = profile;
    }

    @Nonnull
    public UUID getPlayerUUID() {
        return this.uniqueId;
    }

    @Nonnull
    public PlayerProfile getProfile() {
        return this.profile;
    }

    public void setProfile(@Nonnull PlayerProfile profile) {
        Validate.notNull((Object)profile, (String)"The PlayerProfile cannot be null!");
        Validate.isTrue((boolean)profile.getUUID().equals(this.uniqueId), (String)"Cannot inject a PlayerProfile with a different UUID");
        this.profile = profile;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return AsyncProfileLoadEvent.getHandlerList();
    }
}

