/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PressureChamber
extends MultiBlockMachine {
    @ParametersAreNonnullByDefault
    public PressureChamber(Category category, SlimefunItemStack item) {
        super(category, item, new ItemStack[]{new ItemStack(Material.SMOOTH_STONE_SLAB), new CustomItem(Material.DISPENSER, "Dispenser (Facing down)", new String[0]), new ItemStack(Material.SMOOTH_STONE_SLAB), new ItemStack(Material.PISTON), new ItemStack(Material.GLASS), new ItemStack(Material.PISTON), new ItemStack(Material.PISTON), new ItemStack(Material.CAULDRON), new ItemStack(Material.PISTON)}, BlockFace.UP);
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.recipes.stream().map(items -> items[0]).collect(Collectors.toList());
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block dispBlock = b.getRelative(BlockFace.UP).getRelative(BlockFace.UP);
        BlockState state = PaperLib.getBlockState(dispBlock, false).getState();
        if (state instanceof Dispenser) {
            Dispenser disp = (Dispenser)state;
            Inventory inv = disp.getInventory();
            for (ItemStack current : inv.getContents()) {
                for (ItemStack convert : RecipeType.getRecipeInputs(this)) {
                    if (convert == null || !SlimefunUtils.isItemSimilar(current, convert, true)) continue;
                    ItemStack output = RecipeType.getRecipeOutput(this, convert);
                    Inventory outputInv = this.findOutputInventory(output, dispBlock, inv);
                    if (outputInv != null) {
                        ItemStack removing = current.clone();
                        removing.setAmount(convert.getAmount());
                        inv.removeItem(new ItemStack[]{removing});
                        this.craft(p, b, output, outputInv);
                    } else {
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
                    }
                    return;
                }
            }
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.unknown-material", true);
        }
    }

    @ParametersAreNonnullByDefault
    private void craft(Player p, Block b, ItemStack output, Inventory outputInv) {
        for (int i = 0; i < 4; ++i) {
            int j = i;
            SlimefunPlugin.runSync(() -> {
                p.getWorld().playSound(b.getLocation(), Sound.ENTITY_TNT_PRIMED, 1.0f, 1.0f);
                p.getWorld().playEffect(b.getRelative(BlockFace.UP).getLocation(), Effect.SMOKE, 4);
                p.getWorld().playEffect(b.getRelative(BlockFace.UP).getLocation(), Effect.SMOKE, 4);
                p.getWorld().playEffect(b.getRelative(BlockFace.UP).getLocation(), Effect.SMOKE, 4);
                if (j < 3) {
                    p.getWorld().playSound(b.getLocation(), Sound.ENTITY_TNT_PRIMED, 1.0f, 1.0f);
                } else {
                    p.getWorld().playSound(p.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f);
                    outputInv.addItem(new ItemStack[]{output});
                }
            }, (long)i * 20L);
        }
    }
}

