/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.medical;

import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public abstract class MedicalSupply<T extends ItemHandler>
extends SimpleSlimefunItem<T> {
    private final Set<PotionEffectType> curedEffects = new HashSet<PotionEffectType>();
    private final int healAmount;

    @ParametersAreNonnullByDefault
    protected MedicalSupply(Category category, int healAmount, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.healAmount = healAmount;
        this.curedEffects.add(PotionEffectType.POISON);
        this.curedEffects.add(PotionEffectType.WITHER);
        this.curedEffects.add(PotionEffectType.SLOW);
        this.curedEffects.add(PotionEffectType.SLOW_DIGGING);
        this.curedEffects.add(PotionEffectType.WEAKNESS);
        this.curedEffects.add(PotionEffectType.CONFUSION);
        this.curedEffects.add(PotionEffectType.BLINDNESS);
        this.curedEffects.add(PotionEffectType.BAD_OMEN);
    }

    @Nonnull
    public Set<PotionEffectType> getCuredEffects() {
        return Collections.unmodifiableSet(this.curedEffects);
    }

    public void clearNegativeEffects(@Nonnull LivingEntity n) {
        for (PotionEffectType effect : this.curedEffects) {
            if (!n.hasPotionEffect(effect)) continue;
            n.removePotionEffect(effect);
        }
    }

    public void heal(@Nonnull LivingEntity n) {
        double health = n.getHealth() + (double)this.healAmount;
        double maxHealth = n.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        n.setHealth(Math.min(health, maxHealth));
    }
}

