/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.entities;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.entities.AnimalProduce;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Goat;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MushroomCow;
import org.bukkit.inventory.ItemStack;

public class ProduceCollector
extends AContainer
implements RecipeDisplayItem {
    private final ItemSetting<Integer> range = new IntRangeSetting(this, "range", 1, 2, 32);
    private final Set<AnimalProduce> animalProduces = new HashSet<AnimalProduce>();

    @ParametersAreNonnullByDefault
    public ProduceCollector(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.range);
    }

    @Override
    protected void registerDefaultRecipes() {
        this.addProduce(new AnimalProduce(new ItemStack(Material.BUCKET), new ItemStack(Material.MILK_BUCKET), n -> {
            MinecraftVersion version = SlimefunPlugin.getMinecraftVersion();
            if (n instanceof Cow || version.isAtLeast(MinecraftVersion.MINECRAFT_1_17) && n instanceof Goat) {
                return ((Ageable)n).isAdult();
            }
            return false;
        }));
        this.addProduce(new AnimalProduce(new ItemStack(Material.BOWL), new ItemStack(Material.MUSHROOM_STEW), n -> {
            if (n instanceof MushroomCow) {
                return ((MushroomCow)n).isAdult();
            }
            return false;
        }));
    }

    public void addProduce(@Nonnull AnimalProduce produce) {
        Validate.notNull((Object)produce, (String)"A produce cannot be null");
        this.animalProduces.add(produce);
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                ProduceCollector.this.tick(b);
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
    }

    @Override
    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        displayRecipes.add(new CustomItem(Material.BUCKET, null, "&fRequires &bCow &fnearby"));
        displayRecipes.add(new ItemStack(Material.MILK_BUCKET));
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_17)) {
            displayRecipes.add(new CustomItem(Material.BUCKET, null, "&fRequires &bGoat &fnearby"));
            displayRecipes.add(new ItemStack(Material.MILK_BUCKET));
        }
        displayRecipes.add(new CustomItem(Material.BOWL, null, "&fRequires &bMooshroom &fnearby"));
        displayRecipes.add(new ItemStack(Material.MUSHROOM_STEW));
        return displayRecipes;
    }

    @Override
    @Nonnull
    protected MachineRecipe findNextRecipe(@Nonnull BlockMenu inv) {
        for (int slot : this.getInputSlots()) {
            for (AnimalProduce produce : this.animalProduces) {
                ItemStack item = inv.getItemInSlot(slot);
                if (!SlimefunUtils.isItemSimilar(item, produce.getInput()[0], true) || !InvUtils.fits(inv.toInventory(), produce.getOutput()[0], this.getOutputSlots()) || !this.isAnimalNearby(inv.getBlock(), produce)) continue;
                inv.consumeItem(slot);
                return produce;
            }
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    private boolean isAnimalNearby(Block b, Predicate<LivingEntity> predicate) {
        int radius = this.range.getValue();
        return !b.getWorld().getNearbyEntities(b.getLocation(), (double)radius, (double)radius, (double)radius, n -> this.isValidAnimal((Entity)n, predicate)).isEmpty();
    }

    @ParametersAreNonnullByDefault
    private boolean isValidAnimal(Entity n, Predicate<LivingEntity> predicate) {
        if (n instanceof LivingEntity) {
            return predicate.test((LivingEntity)n);
        }
        return false;
    }

    @Override
    @Nonnull
    public String getMachineIdentifier() {
        return "PRODUCE_COLLECTOR";
    }

    @Override
    @Nonnull
    public ItemStack getProgressBar() {
        return new ItemStack(Material.SHEARS);
    }
}

