/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest.apache;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.Config;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Headers;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.RawResponseBase;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnirestException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

class ApacheResponse
extends RawResponseBase {
    private final HttpResponse r;

    public ApacheResponse(HttpResponse r, Config config) {
        super(config);
        this.r = r;
    }

    @Override
    public int getStatus() {
        return this.r.getStatusLine().getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.r.getStatusLine().getReasonPhrase();
    }

    @Override
    public Headers getHeaders() {
        Headers h = new Headers();
        Stream.of(this.r.getAllHeaders()).forEachOrdered(e -> h.add(e.getName(), e.getValue()));
        return h;
    }

    @Override
    public InputStream getContent() {
        try {
            HttpEntity entity = this.r.getEntity();
            if (entity != null) {
                return entity.getContent();
            }
            return new ByteArrayInputStream(new byte[0]);
        }
        catch (IOException e) {
            throw new UnirestException(e);
        }
    }

    @Override
    public byte[] getContentAsBytes() {
        if (!this.hasContent()) {
            return new byte[0];
        }
        try {
            InputStream is = this.getContent();
            if (is.available() > 0 && ApacheResponse.isGzipped(this.getEncoding())) {
                is = new GZIPInputStream(this.getContent());
            }
            byte[] byArray = ApacheResponse.getBytes(is);
            return byArray;
        }
        catch (IOException e2) {
            throw new UnirestException(e2);
        }
        finally {
            EntityUtils.consumeQuietly(this.r.getEntity());
        }
    }

    @Override
    public String getContentAsString() {
        return this.getContentAsString(null);
    }

    @Override
    public String getContentAsString(String charset) {
        if (!this.hasContent()) {
            return "";
        }
        try {
            String charSet = this.getCharset(charset);
            return new String(this.getContentAsBytes(), charSet);
        }
        catch (IOException e) {
            throw new UnirestException(e);
        }
    }

    private String getCharset(String charset) {
        if (charset == null || charset.trim().isEmpty()) {
            return this.getCharSet();
        }
        return charset;
    }

    @Override
    public InputStreamReader getContentReader() {
        return new InputStreamReader(this.getContent());
    }

    @Override
    public boolean hasContent() {
        return this.r.getEntity() != null;
    }

    @Override
    public String getContentType() {
        Header contentType;
        if (this.hasContent() && (contentType = this.r.getEntity().getContentType()) != null) {
            return contentType.getValue();
        }
        return "";
    }

    @Override
    public String getEncoding() {
        Header contentType;
        if (this.hasContent() && (contentType = this.r.getEntity().getContentEncoding()) != null) {
            return contentType.getValue();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(InputStream is) throws IOException {
        try {
            byte[] buf;
            int size = 1024;
            if (is instanceof ByteArrayInputStream) {
                size = is.available();
                buf = new byte[size];
                int len = is.read(buf, 0, size);
            } else {
                int len;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                buf = new byte[size];
                while ((len = is.read(buf, 0, size)) != -1) {
                    bos.write(buf, 0, len);
                }
                buf = bos.toByteArray();
            }
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            is.close();
        }
    }

    private static boolean isGzipped(String value) {
        return "gzip".equalsIgnoreCase(value.toLowerCase().trim());
    }
}

