/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.network;

import io.github.thebusybiscuit.slimefun4.api.network.Network;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;

class NetworkVisualizer
implements Runnable {
    private final Particle.DustOptions particleOptions;
    private final Network network;

    NetworkVisualizer(@Nonnull Network network, @Nonnull Color color) {
        Validate.notNull((Object)network, (String)"The network should not be null.");
        Validate.notNull((Object)color, (String)"The color cannot be null.");
        this.network = network;
        this.particleOptions = new Particle.DustOptions(color, 3.0f);
    }

    @Override
    public void run() {
        for (Location l : this.network.connectorNodes) {
            this.spawnParticles(l);
        }
        for (Location l : this.network.terminusNodes) {
            this.spawnParticles(l);
        }
    }

    private void spawnParticles(@Nonnull Location l) {
        l.getWorld().spawnParticle(Particle.REDSTONE, l.getX() + 0.5, l.getY() + 0.5, l.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 1.0, (Object)this.particleOptions);
    }
}

