/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.localization;

import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;

public enum LanguageFile {
    MESSAGES("messages.yml"),
    CATEGORIES("categories.yml"),
    RECIPES("recipes.yml"),
    RESOURCES("resources.yml"),
    RESEARCHES("researches.yml");

    protected static final LanguageFile[] valuesCached;
    private final String fileName;

    private LanguageFile(String fileName) {
        this.fileName = fileName;
    }

    @Nonnull
    public String getFilePath(@Nonnull Language language) {
        return this.getFilePath(language.getId());
    }

    @Nonnull
    public String getFilePath(@Nonnull String languageId) {
        Validate.notNull((Object)languageId, (String)"Language id must not be null!");
        return "/languages/" + languageId + '/' + this.fileName;
    }

    static {
        valuesCached = LanguageFile.values();
    }
}

