/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.thebusybiscuit.slimefun4.core.services.github.ContributorRole;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

final class TranslatorsReader {
    private final GitHubService github;

    TranslatorsReader(@Nonnull GitHubService github) {
        this.github = github;
    }

    public void load() {
        InputStream inputStream = SlimefunPlugin.class.getResourceAsStream("/languages/translators.json");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse(reader.lines().collect(Collectors.joining("")));
            JsonObject json = element.getAsJsonObject();
            for (Map.Entry entry : json.entrySet()) {
                String languageCode = (String)entry.getKey();
                if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                String role = ContributorRole.TRANSLATOR.getId() + ',' + languageCode;
                JsonArray users = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (JsonElement user : users) {
                    this.github.addContributor(user.getAsString(), role, 0);
                }
            }
        }
        catch (Exception e) {
            SlimefunPlugin.logger().log(Level.SEVERE, "Failed to load translators.json file", e);
        }
    }
}

