/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.ContributorRole;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.JsonNode;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.json.JSONArray;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

class ContributionsConnector
extends GitHubConnector {
    private final List<String> ignoredAccounts = new ArrayList<String>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final String prefix;
    private final String role;
    private final int page;
    private boolean finished = false;

    @ParametersAreNonnullByDefault
    ContributionsConnector(GitHubService github, String prefix, int page, String repository, ContributorRole role) {
        super(github, repository);
        this.prefix = prefix;
        this.page = page;
        this.role = role.getId();
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        this.ignoredAccounts.add("invalid-email-address");
        this.ignoredAccounts.add("renovate");
        this.ignoredAccounts.add("renovate-bot");
        this.ignoredAccounts.add("renovate[bot]");
        this.ignoredAccounts.add("TheBusyBot");
        this.ignoredAccounts.add("ImgBotApp");
        this.ignoredAccounts.add("imgbot");
        this.ignoredAccounts.add("imgbot[bot]");
        this.ignoredAccounts.add("github-actions[bot]");
        this.ignoredAccounts.add("gitlocalize-app");
        this.ignoredAccounts.add("gitlocalize-app[bot]");
        this.ignoredAccounts.add("mt-gitlocalize");
        this.aliases.put("WalshyDev", "HumanRightsAct");
        this.aliases.put("J3fftw1", "_lagpc_");
        this.aliases.put("ajan-12", "ajan_12");
        this.aliases.put("mrcoffee1026", "mr_coffee1026");
        this.aliases.put("Cyber-MC", "CyberPatriot");
        this.aliases.put("BurningBrimstone", "Bluedevil74");
        this.aliases.put("bverhoeven", "soczol");
        this.aliases.put("ramdon-person", "ramdon_person");
        this.aliases.put("NCBPFluffyBear", "FluffyBear_");
        this.aliases.put("martinbrom", "OneTime97");
    }

    public boolean hasFinished() {
        return this.finished;
    }

    @Override
    public void onSuccess(@Nonnull JsonNode response) {
        this.finished = true;
        if (response.isArray()) {
            this.computeContributors(response.getArray());
        } else {
            SlimefunPlugin.logger().log(Level.WARNING, "Received an unusual answer from GitHub, possibly a timeout? ({0})", response);
        }
    }

    @Override
    public void onFailure() {
        this.finished = true;
    }

    @Override
    public String getFileName() {
        return this.prefix + "_contributors";
    }

    @Override
    public String getEndpoint() {
        return "/contributors";
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("per_page", 100);
        parameters.put("page", this.page);
        return parameters;
    }

    private void computeContributors(@Nonnull JSONArray array) {
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.getJSONObject(i);
            String name = object.getString("login");
            int commits = object.getInt("contributions");
            String profile = object.getString("html_url");
            if (this.ignoredAccounts.contains(name)) continue;
            String username = this.aliases.getOrDefault(name, name);
            this.github.addContributor(username, profile, this.role, commits);
        }
    }
}

