/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.ProgressMonitor;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.RawResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

class MonitoringInputStream
extends InputStream {
    private final InputStream content;
    private final ProgressMonitor downloadMonitor;
    private long totalSize;
    private long byteCount = 0L;
    private String fileName;

    MonitoringInputStream(InputStream content, ProgressMonitor downloadMonitor, Path target, RawResponse contentSize) {
        this.content = content;
        this.downloadMonitor = downloadMonitor;
        this.fileName = target.getFileName().toString();
        this.totalSize = this.getBodySize(contentSize);
    }

    private Long getBodySize(RawResponse r) {
        String header = r.getHeaders().getFirst("Content-Length");
        if (header != null && header.length() > 0) {
            return Long.valueOf(header);
        }
        return 0L;
    }

    @Override
    public int read() throws IOException {
        return this.content.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        this.monitor(read);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.monitor(read);
        return read;
    }

    private void monitor(int bytesRead) {
        this.byteCount += (long)bytesRead;
        this.downloadMonitor.accept("body", this.fileName, this.byteCount, this.totalSize);
    }

    @Override
    public void close() throws IOException {
        this.content.close();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.content.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.content.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.content.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.content.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.content.reset();
    }
}

