/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.players;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.players.TooManyRequestsException;

public final class MinecraftAccount {
    private static final Pattern UUID_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final String ERROR_TOKEN = "error";
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final Pattern NAME_PATTERN = Pattern.compile("[\\w_]+");

    private MinecraftAccount() {
    }

    @Nonnull
    public static Optional<UUID> getUUID(@NonNull String name) throws IOException, TooManyRequestsException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("\"" + name + "\" is not a valid Minecraft Username!");
        }
        Optional<URL> url = MinecraftAccount.getURL("https://api.mojang.com/users/profiles/minecraft/" + name);
        if (url.isPresent()) {
            try (InputStreamReader reader = new InputStreamReader(url.get().openStream(), StandardCharsets.UTF_8);){
                JsonElement element = JSON_PARSER.parse((Reader)reader);
                if (!(element instanceof JsonNull)) {
                    JsonObject obj = element.getAsJsonObject();
                    if (obj.has(ERROR_TOKEN)) {
                        String error = obj.get(ERROR_TOKEN).getAsString();
                        if (error.equals("TooManyRequestsException")) {
                            throw new TooManyRequestsException(url.orElse(null));
                        }
                        throw new UnknownServiceException(error);
                    }
                    String id = obj.get("id").getAsString();
                    Optional<UUID> optional = Optional.of(UUID.fromString(UUID_PATTERN.matcher(id).replaceAll("$1-$2-$3-$4-$5")));
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<String> getSkin(@NonNull UUID uuid) throws TooManyRequestsException, IOException {
        block20: {
            if (uuid == null) {
                throw new NullPointerException("uuid is marked non-null but is null");
            }
            Optional<URL> url = MinecraftAccount.getURL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "") + "?unsigned=false");
            if (url.isPresent()) {
                try (InputStreamReader reader = new InputStreamReader(url.get().openStream(), StandardCharsets.UTF_8);){
                    JsonElement element = JSON_PARSER.parse((Reader)reader);
                    if (element instanceof JsonNull) break block20;
                    JsonObject obj = element.getAsJsonObject();
                    if (obj.has(ERROR_TOKEN)) {
                        String error = obj.get(ERROR_TOKEN).getAsString();
                        if (error.equals("TooManyRequestsException")) {
                            throw new TooManyRequestsException(url.orElse(null));
                        }
                        throw new UnknownServiceException(error);
                    }
                    JsonArray properties = obj.get("properties").getAsJsonArray();
                    for (JsonElement el : properties) {
                        if (!el.isJsonObject() || !el.getAsJsonObject().get("name").getAsString().equals("textures")) continue;
                        Optional<String> optional = Optional.ofNullable(el.getAsJsonObject().get("value").getAsString());
                        return optional;
                    }
                }
            }
        }
        return Optional.empty();
    }

    @Nonnull
    private static Optional<URL> getURL(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            return Optional.of(new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

