/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.player;

import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;

public class StatusEffect
implements Keyed {
    private final NamespacedKey key;

    public StatusEffect(@Nonnull NamespacedKey key) {
        this.key = key;
    }

    @Nonnull
    public NamespacedKey getKey() {
        return this.key;
    }

    public void add(@Nonnull Player p, int duration, @Nonnull TimeUnit unit) {
        this.add(p, 1, duration, unit);
    }

    public void add(@Nonnull Player p, int level, int duration, @Nonnull TimeUnit unit) {
        PersistentDataAPI.setString((PersistentDataHolder)p, this.getKey(), level + ";" + System.currentTimeMillis() + unit.toMillis(duration));
    }

    public void addPermanent(@Nonnull Player p, int level) {
        PersistentDataAPI.setString((PersistentDataHolder)p, this.getKey(), level + ";0");
    }

    public boolean isPresent(@Nonnull Player p) {
        Optional<String> optional = PersistentDataAPI.getOptionalString((PersistentDataHolder)p, this.getKey());
        if (optional.isPresent()) {
            String[] data = PatternUtils.SEMICOLON.split(optional.get());
            long timestamp = Long.parseLong(data[1]);
            if (timestamp == 0L || timestamp >= System.currentTimeMillis()) {
                return true;
            }
            this.clear(p);
            return false;
        }
        return false;
    }

    @Nonnull
    public OptionalInt getLevel(@Nonnull Player p) {
        Optional<String> optional = PersistentDataAPI.getOptionalString((PersistentDataHolder)p, this.getKey());
        if (optional.isPresent()) {
            String[] data = PatternUtils.SEMICOLON.split(optional.get());
            return OptionalInt.of(Integer.parseInt(data[0]));
        }
        return OptionalInt.empty();
    }

    public void clear(@Nonnull Player p) {
        PersistentDataAPI.remove((PersistentDataHolder)p, this.getKey());
    }
}

