/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.elevator.ElevatorPlate;
import io.github.thebusybiscuit.slimefun4.implementation.items.teleporter.AbstractTeleporterPlate;
import io.github.thebusybiscuit.slimefun4.implementation.items.teleporter.Teleporter;
import io.github.thebusybiscuit.slimefun4.implementation.items.teleporter.TeleporterPylon;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class TeleporterListener
implements Listener {
    private final BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};

    public TeleporterListener(@Nonnull SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPressurePlateEnter(PlayerInteractEvent e) {
        SlimefunItem teleporter;
        if (e.getAction() != Action.PHYSICAL || e.getClickedBlock() == null) {
            return;
        }
        Block b = e.getClickedBlock();
        SlimefunItem item = BlockStorage.check(b);
        Player p = e.getPlayer();
        if (item instanceof ElevatorPlate) {
            ElevatorPlate elevator = SlimefunItems.ELEVATOR_PLATE.getItem(ElevatorPlate.class);
            elevator.openInterface(p, b);
        } else if (item instanceof AbstractTeleporterPlate && ((AbstractTeleporterPlate)item).hasAccess(p, b) && (teleporter = BlockStorage.check(b.getRelative(BlockFace.DOWN))) instanceof Teleporter && this.checkForPylons(b.getRelative(BlockFace.DOWN))) {
            Block block = b.getRelative(BlockFace.DOWN);
            UUID owner = UUID.fromString(BlockStorage.getLocationInfo(block.getLocation(), "owner"));
            SlimefunPlugin.getGPSNetwork().getTeleportationManager().openTeleporterGUI(p, owner, block, SlimefunPlugin.getGPSNetwork().getNetworkComplexity(owner));
        }
    }

    private boolean checkForPylons(@Nonnull Block teleporter) {
        for (BlockFace face : this.faces) {
            if (BlockStorage.check(teleporter.getRelative(face)) instanceof TeleporterPylon) continue;
            return false;
        }
        return true;
    }
}

