/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.attributes;

import io.github.thebusybiscuit.slimefun4.core.attributes.ItemAttribute;
import io.github.thebusybiscuit.slimefun4.utils.ChargeUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public interface Rechargeable
extends ItemAttribute {
    public float getMaxItemCharge(ItemStack var1);

    default public void setItemCharge(ItemStack item, float charge) {
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("Cannot set Item charge for null or AIR");
        }
        float maximum = this.getMaxItemCharge(item);
        if (charge < 0.0f || charge > maximum) {
            throw new IllegalArgumentException("Charge must be between zero and " + maximum + ".");
        }
        ItemMeta meta = item.getItemMeta();
        ChargeUtils.setCharge(meta, charge, maximum);
        item.setItemMeta(meta);
    }

    default public float getItemCharge(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("Cannot get Item charge for null or AIR");
        }
        return ChargeUtils.getCharge(item.getItemMeta());
    }

    default public boolean addItemCharge(ItemStack item, float charge) {
        float maximum;
        Validate.isTrue((charge > 0.0f ? 1 : 0) != 0, (String)"Charge must be above zero!");
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("Cannot add Item charge for null or AIR");
        }
        ItemMeta meta = item.getItemMeta();
        float currentCharge = ChargeUtils.getCharge(meta);
        if (currentCharge >= (maximum = this.getMaxItemCharge(item))) {
            return false;
        }
        float newCharge = Math.min(currentCharge + charge, maximum);
        ChargeUtils.setCharge(meta, newCharge, maximum);
        item.setItemMeta(meta);
        return true;
    }

    default public boolean removeItemCharge(ItemStack item, float charge) {
        Validate.isTrue((charge > 0.0f ? 1 : 0) != 0, (String)"Charge must be above zero!");
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("Cannot remove Item charge for null or AIR");
        }
        ItemMeta meta = item.getItemMeta();
        float currentCharge = ChargeUtils.getCharge(meta);
        if (currentCharge < charge) {
            return false;
        }
        float newCharge = Math.max(currentCharge - charge, 0.0f);
        ChargeUtils.setCharge(meta, newCharge, this.getMaxItemCharge(item));
        item.setItemMeta(meta);
        return true;
    }
}

