/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.commands.subcommands;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.SubCommand;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.Set;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;

class VersionsCommand
extends SubCommand {
    VersionsCommand(SlimefunPlugin plugin, SlimefunCommand cmd) {
        super(plugin, cmd, "versions", false);
    }

    @Override
    public void onExecute(@Nonnull CommandSender sender, @Nonnull String[] args) {
        if (sender.hasPermission("slimefun.command.versions") || sender instanceof ConsoleCommandSender) {
            String serverSoftware = PaperLib.isSpigot() && !PaperLib.isPaper() ? "Spigot" : Bukkit.getName();
            ComponentBuilder builder = new ComponentBuilder();
            builder.append("This Server uses the following setup of Slimefun:\n").color(ChatColor.GRAY).append(serverSoftware).color(ChatColor.GREEN).append(" " + Bukkit.getVersion() + '\n').color(ChatColor.DARK_GREEN).append("Slimefun ").color(ChatColor.GREEN).append(SlimefunPlugin.getVersion() + '\n').color(ChatColor.DARK_GREEN);
            if (SlimefunPlugin.getMetricsService().getVersion() != null) {
                builder.append("Metrics-Module ").color(ChatColor.GREEN).append("#" + SlimefunPlugin.getMetricsService().getVersion() + '\n').color(ChatColor.DARK_GREEN);
            }
            this.addJavaVersion(builder);
            if (SlimefunPlugin.getRegistry().isBackwardsCompatible()) {
                HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Backwards compatibility has a negative impact on performance!\nWe recommend you to disable this setting unless your server still has legacy Slimefun items (from before summer 2019) in circulation.")});
                builder.append("\nBackwards compatibility enabled!\n").color(ChatColor.RED).event(hoverEvent);
            }
            builder.append("\n").event((HoverEvent)null);
            this.addPluginVersions(builder);
            sender.spigot().sendMessage(builder.create());
        } else {
            SlimefunPlugin.getLocalization().sendMessage(sender, "messages.no-permission", true);
        }
    }

    private void addJavaVersion(@Nonnull ComponentBuilder builder) {
        int version;
        String javaVer = System.getProperty("java.version");
        if (javaVer.startsWith("1.")) {
            javaVer = javaVer.substring(2);
        }
        if (javaVer.indexOf(46) != -1) {
            javaVer = javaVer.substring(0, javaVer.indexOf(46));
        }
        if ((version = Integer.parseInt(javaVer)) < 11) {
            builder.append("Java " + version).color(ChatColor.RED).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Your Java version is out of date!\n!You should use Java 11 or higher.\nPaper will be dropping support for older versions with the release of Minecraft 1.17.")})).append("\n").event((HoverEvent)null);
        } else {
            builder.append("Java ").color(ChatColor.GREEN).append(version + "\n").color(ChatColor.DARK_GREEN);
        }
    }

    private void addPluginVersions(@Nonnull ComponentBuilder builder) {
        Set<Plugin> addons = SlimefunPlugin.getInstalledAddons();
        if (addons.isEmpty()) {
            builder.append("No Addons installed").color(ChatColor.GRAY).italic(true);
            return;
        }
        builder.append("Installed Addons: ").color(ChatColor.GRAY).append("(" + addons.size() + ")").color(ChatColor.DARK_GRAY);
        for (Plugin plugin : addons) {
            ChatColor secondaryColor;
            ChatColor primaryColor;
            String version = plugin.getDescription().getVersion();
            HoverEvent hoverEvent = null;
            ClickEvent clickEvent = null;
            if (Bukkit.getPluginManager().isPluginEnabled(plugin)) {
                primaryColor = ChatColor.GREEN;
                secondaryColor = ChatColor.DARK_GREEN;
                String authors = String.join((CharSequence)", ", plugin.getDescription().getAuthors());
                if (plugin instanceof SlimefunAddon && ((SlimefunAddon)plugin).getBugTrackerURL() != null) {
                    hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(new ComponentBuilder().append("Author(s): ").append(authors).color(ChatColor.YELLOW).append("\n> Click here to go to their issues tracker").color(ChatColor.GOLD).create())});
                    clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, ((SlimefunAddon)plugin).getBugTrackerURL());
                } else {
                    hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(new ComponentBuilder().append("Author(s): ").append(authors).color(ChatColor.YELLOW).create())});
                }
            } else {
                primaryColor = ChatColor.RED;
                secondaryColor = ChatColor.DARK_RED;
                if (plugin instanceof SlimefunAddon && ((SlimefunAddon)plugin).getBugTrackerURL() != null) {
                    hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(new ComponentBuilder().append("This plugin is disabled.\nCheck the console for an error message.").color(ChatColor.RED).append("\n> Click here to report on their issues tracker").color(ChatColor.DARK_RED).create())});
                    SlimefunAddon addon = (SlimefunAddon)plugin;
                    if (addon.getBugTrackerURL() != null) {
                        clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, addon.getBugTrackerURL());
                    }
                } else {
                    hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Plugin is disabled. Check the console for an error and report on their issues tracker.")});
                }
            }
            builder.append("\n  " + plugin.getName()).color(primaryColor).event(hoverEvent).event(clickEvent).append(" v" + version).color(secondaryColor).append("").event((ClickEvent)null).event((HoverEvent)null);
        }
    }
}

