/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.implementation.handlers.VanillaInventoryDropHandler;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OutputChest
extends SlimefunItem {
    private static final BlockFace[] possibleFaces = new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};

    @ParametersAreNonnullByDefault
    public OutputChest(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(new VanillaInventoryDropHandler<Chest>(Chest.class));
    }

    @Nonnull
    public static Optional<Inventory> findOutputChestFor(@Nonnull Block b, @Nonnull ItemStack item) {
        for (BlockFace face : possibleFaces) {
            Inventory inv;
            BlockState state;
            SlimefunItem slimefunItem;
            Block potentialOutput = b.getRelative(face);
            if (potentialOutput.getType() != Material.CHEST || !((slimefunItem = BlockStorage.check(potentialOutput)) instanceof OutputChest) || slimefunItem.isDisabledIn(b.getWorld()) || !((state = PaperLib.getBlockState(potentialOutput, false).getState()) instanceof Chest) || !InvUtils.fits(inv = ((Chest)state).getInventory(), item, new int[0])) continue;
            return Optional.of(inv);
        }
        return Optional.empty();
    }
}

