/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun;

import java.io.File;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.PluginUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Reflection.ReflectionUtils;
import me.mrCookieSlime.Slimefun.AncientAltar.Pedestals;
import me.mrCookieSlime.Slimefun.CSCoreLibSetup.CSCoreLibLoader;
import me.mrCookieSlime.Slimefun.Commands.SlimefunCommand;
import me.mrCookieSlime.Slimefun.Commands.SlimefunTabCompleter;
import me.mrCookieSlime.Slimefun.GEO.OreGenSystem;
import me.mrCookieSlime.Slimefun.GEO.Resources.NetherIceResource;
import me.mrCookieSlime.Slimefun.GEO.Resources.OilResource;
import me.mrCookieSlime.Slimefun.GPS.Elevator;
import me.mrCookieSlime.Slimefun.GitHub.GitHubConnector;
import me.mrCookieSlime.Slimefun.GitHub.GitHubSetup;
import me.mrCookieSlime.Slimefun.Hashing.ItemHash;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.MultiBlock;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunArmorPiece;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.AutoEnchanter;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.ElectricDustWasher;
import me.mrCookieSlime.Slimefun.Setup.Files;
import me.mrCookieSlime.Slimefun.Setup.Messages;
import me.mrCookieSlime.Slimefun.Setup.MiscSetup;
import me.mrCookieSlime.Slimefun.Setup.ResearchSetup;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.Setup.SlimefunSetup;
import me.mrCookieSlime.Slimefun.SlimefunGuide;
import me.mrCookieSlime.Slimefun.URID.AutoSavingTask;
import me.mrCookieSlime.Slimefun.URID.URID;
import me.mrCookieSlime.Slimefun.Variables;
import me.mrCookieSlime.Slimefun.WorldEdit.WESlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunBackup;
import me.mrCookieSlime.Slimefun.api.TickerTask;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.energy.EnergyNet;
import me.mrCookieSlime.Slimefun.api.energy.ItemEnergy;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.CargoNet;
import me.mrCookieSlime.Slimefun.api.item_transport.ChestManipulator;
import me.mrCookieSlime.Slimefun.listeners.AncientAltarListener;
import me.mrCookieSlime.Slimefun.listeners.AndroidKillingListener;
import me.mrCookieSlime.Slimefun.listeners.ArmorListener;
import me.mrCookieSlime.Slimefun.listeners.AutonomousToolsListener;
import me.mrCookieSlime.Slimefun.listeners.BackpackListener;
import me.mrCookieSlime.Slimefun.listeners.BlockListener;
import me.mrCookieSlime.Slimefun.listeners.BowListener;
import me.mrCookieSlime.Slimefun.listeners.ClearLaggIntegration;
import me.mrCookieSlime.Slimefun.listeners.CoolerListener;
import me.mrCookieSlime.Slimefun.listeners.DamageListener;
import me.mrCookieSlime.Slimefun.listeners.FurnaceListener;
import me.mrCookieSlime.Slimefun.listeners.GearListener;
import me.mrCookieSlime.Slimefun.listeners.GuideOnJoinListener;
import me.mrCookieSlime.Slimefun.listeners.ItemListener;
import me.mrCookieSlime.Slimefun.listeners.ItemPickupListener;
import me.mrCookieSlime.Slimefun.listeners.NetworkListener;
import me.mrCookieSlime.Slimefun.listeners.PlayerQuitListener;
import me.mrCookieSlime.Slimefun.listeners.TalismanListener;
import me.mrCookieSlime.Slimefun.listeners.TeleporterListener;
import me.mrCookieSlime.Slimefun.listeners.ToolListener;
import me.mrCookieSlime.Slimefun.listeners.WorldListener;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SlimefunStartup
extends JavaPlugin {
    public static SlimefunStartup instance;
    static PluginUtils utils;
    static Config researches;
    static Config items;
    static Config whitelist;
    static Config config;
    public static TickerTask ticker;
    private CoreProtectAPI coreProtectAPI;
    private boolean clearlag = false;
    private boolean exoticGarden = false;
    private boolean coreProtect = false;
    final String[] supported = new String[]{"v1_13_"};

    public void onEnable() {
        CSCoreLibLoader loader = new CSCoreLibLoader((Plugin)this);
        if (loader.load()) {
            String currentVersion = ReflectionUtils.getVersion();
            if (currentVersion.startsWith("v")) {
                boolean compatibleVersion = false;
                StringBuilder versions = new StringBuilder();
                int i = 0;
                String[] stringArray = this.supported;
                int n = stringArray.length;
                for (int j = 0; j < n; ++j) {
                    String version = stringArray[j];
                    if (currentVersion.startsWith(version)) {
                        compatibleVersion = true;
                    }
                    if (i == 0) {
                        versions.append(version.substring(1).replaceFirst("_", ".").replace("_", ".X"));
                    } else if (i == this.supported.length - 1) {
                        versions.append(" or " + version.substring(1).replaceFirst("_", ".").replace("_", ".X"));
                    } else {
                        versions.append(", " + version.substring(1).replaceFirst("_", ".").replace("_", ".X"));
                    }
                    ++i;
                }
                if (!compatibleVersion) {
                    System.err.println("### Slimefun failed to load!");
                    System.err.println("###");
                    System.err.println("### You are using the wrong Version of Minecraft!!!");
                    System.err.println("###");
                    System.err.println("### You are using Minecraft " + ReflectionUtils.getVersion());
                    System.err.println("### but Slimefun v" + this.getDescription().getVersion() + " requires you to be using");
                    System.err.println("### Minecraft " + versions.toString());
                    System.err.println("###");
                    System.err.println("### Please use an older Version of Slimefun and disable auto-updating");
                    System.err.println("### or consider updating your Server Software.");
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    return;
                }
            }
            instance = this;
            System.out.println("[Slimefun] Loading Files...");
            Files.cleanup();
            System.out.println("[Slimefun] Loading Config...");
            utils = new PluginUtils((Plugin)this);
            utils.setupConfig();
            researches = new Config(Files.RESEARCHES);
            items = new Config(Files.ITEMS);
            whitelist = new Config(Files.WHITELIST);
            utils.setupUpdater(53485, this.getFile());
            utils.setupMetrics();
            utils.setupLocalization();
            config = utils.getConfig();
            Messages.local = utils.getLocalization();
            Messages.setup();
            String[] storage = new String[]{"blocks", "stored-blocks", "stored-inventories", "stored-chunks", "universal-inventories", "waypoints", "block-backups"};
            String[] general = new String[]{"scripts", "generators", "error-reports", "cache/github"};
            for (String s : storage) {
                this.createDir("data-storage/Slimefun/" + s);
            }
            for (String s : general) {
                this.createDir("plugins/Slimefun/" + s);
            }
            SlimefunManager.plugin = this;
            System.out.println("[Slimefun] Loading Items...");
            MiscSetup.setupItemSettings();
            try {
                SlimefunSetup.setupItems();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            MiscSetup.loadDescriptions();
            System.out.println("[Slimefun] Loading Researches...");
            Research.enabled = SlimefunStartup.getResearchCfg().getBoolean("enable-researching");
            ResearchSetup.setupResearches();
            MiscSetup.setupMisc();
            BlockStorage.info_delay = config.getInt("URID.info-delay");
            System.out.println("[Slimefun] Loading World Generators...");
            OreGenSystem.registerResource(new OilResource());
            OreGenSystem.registerResource(new NetherIceResource());
            GitHubSetup.setup();
            new ArmorListener(this);
            new ItemListener(this);
            new BlockListener(this);
            new GearListener(this);
            new AutonomousToolsListener(this);
            new DamageListener(this);
            new BowListener(this);
            new ToolListener(this);
            new FurnaceListener(this);
            new TeleporterListener(this);
            new AndroidKillingListener(this);
            new NetworkListener(this);
            new ItemPickupListener(this);
            if (config.getBoolean("items.talismans")) {
                new TalismanListener(this);
            }
            if (config.getBoolean("items.backpacks")) {
                new BackpackListener(this);
            }
            if (config.getBoolean("items.coolers")) {
                new CoolerListener(this);
            }
            if (config.getBoolean("options.give-guide-on-first-join")) {
                new GuideOnJoinListener(this);
            }
            new WorldListener(this);
            new PlayerQuitListener(this);
            this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
                Slimefun.emeraldenchants = this.getServer().getPluginManager().isPluginEnabled("EmeraldEnchants");
                SlimefunGuide.all_recipes = config.getBoolean("options.show-vanilla-recipes-in-guide");
                MiscSetup.loadItems();
                for (World world : Bukkit.getWorlds()) {
                    new BlockStorage(world);
                }
                if (SlimefunItem.getByID("ANCIENT_ALTAR") != null) {
                    new AncientAltarListener(instance);
                }
            }, 0L);
            if (this.getServer().getPluginManager().isPluginEnabled("WorldEdit")) {
                try {
                    Class.forName("com.sk89q.worldedit.extent.Extent");
                    new WESlimefunManager();
                    System.out.println("[Slimefun] Successfully hooked into WorldEdit!");
                }
                catch (Exception x) {
                    System.err.println("[Slimefun] Failed to hook into WorldEdit!");
                    System.err.println("[Slimefun] Maybe consider updating WorldEdit or Slimefun?");
                }
            }
            this.getCommand("slimefun").setExecutor((CommandExecutor)new SlimefunCommand(this));
            this.getCommand("slimefun").setTabCompleter((TabCompleter)new SlimefunTabCompleter());
            if (config.getBoolean("options.enable-armor-effects")) {
                this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
                    block0: for (Player p : Bukkit.getOnlinePlayers()) {
                        for (ItemStack armor : p.getInventory().getArmorContents()) {
                            if (armor == null || !Slimefun.hasUnlocked(p, armor, true)) continue;
                            if (SlimefunItem.getByItem(armor) instanceof SlimefunArmorPiece) {
                                for (PotionEffect effect : ((SlimefunArmorPiece)SlimefunItem.getByItem(armor)).getEffects()) {
                                    p.removePotionEffect(effect.getType());
                                    p.addPotionEffect(effect);
                                }
                            }
                            if (!SlimefunManager.isItemSimiliar(armor, SlimefunItem.getItem("SOLAR_HELMET"), false) || p.getWorld().getTime() >= 12300L && p.getWorld().getTime() <= 23850L || p.getEyeLocation().getBlock().getLightFromSky() != 15) continue;
                            ItemEnergy.chargeInventory(p, Float.valueOf(String.valueOf(Slimefun.getItemValue("SOLAR_HELMET", "charge-amount"))).floatValue());
                        }
                        for (ItemStack radioactive : SlimefunItem.radioactive) {
                            if (!p.getInventory().containsAtLeast(radioactive, 1) && !SlimefunManager.isItemSimiliar(p.getInventory().getItemInOffHand(), radioactive, true)) continue;
                            if (SlimefunManager.isItemSimiliar(SlimefunItems.SCUBA_HELMET, p.getInventory().getHelmet(), true) && SlimefunManager.isItemSimiliar(SlimefunItems.HAZMATSUIT_CHESTPLATE, p.getInventory().getChestplate(), true) && SlimefunManager.isItemSimiliar(SlimefunItems.HAZMATSUIT_LEGGINGS, p.getInventory().getLeggings(), true) && SlimefunManager.isItemSimiliar(SlimefunItems.RUBBER_BOOTS, p.getInventory().getBoots(), true)) continue block0;
                            if (!Slimefun.isEnabled(p, radioactive, false)) continue;
                            p.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 400, 3));
                            p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 400, 3));
                            p.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 400, 3));
                            p.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 400, 3));
                            p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 400, 1));
                            p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, 400, 1));
                            p.setFireTicks(400);
                            continue block0;
                        }
                    }
                }, 0L, (long)config.getInt("options.armor-update-interval") * 20L);
            }
            ticker = new TickerTask();
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new AutoSavingTask(), 1200L, (long)config.getInt("options.auto-save-delay-in-minutes") * 60L * 20L);
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)ticker, 100L, (long)config.getInt("URID.custom-ticker-delay"));
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                for (GitHubConnector connector : GitHubConnector.connectors) {
                    connector.pullFile();
                }
            }, 80L, 72000L);
            System.out.println("[Slimefun] Finished!");
            this.clearlag = this.getServer().getPluginManager().isPluginEnabled("ClearLag");
            this.coreProtect = this.getServer().getPluginManager().isPluginEnabled("CoreProtect");
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                this.exoticGarden = this.getServer().getPluginManager().isPluginEnabled("ExoticGarden");
            }, 0L);
            if (this.clearlag) {
                new ClearLaggIntegration(this);
            }
            if (this.coreProtect) {
                this.coreProtectAPI = ((CoreProtect)this.getServer().getPluginManager().getPlugin("CoreProtect")).getAPI();
            }
            Research.creative_research = config.getBoolean("options.allow-free-creative-research");
            AutoEnchanter.max_emerald_enchantments = config.getInt("options.emerald-enchantment-limit");
            SlimefunSetup.legacy_ore_washer = config.getBoolean("options.legacy-ore-washer");
            ElectricDustWasher.legacy_dust_washer = config.getBoolean("options.legacy-dust-washer");
            CSCoreLib.getLib().filterLog("([A-Za-z0-9_]{3,16}) issued server command: /sf elevator (.{0,})");
        }
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        SlimefunStartup.ticker.HALTED = true;
        ticker.run();
        try {
            for (World world : Bukkit.getWorlds()) {
                BlockStorage storage = BlockStorage.getStorage(world);
                if (storage != null) {
                    storage.save(true);
                    continue;
                }
                System.err.println("[Slimefun] Could not save Slimefun Blocks for World \"" + world.getName() + "\"");
            }
            SlimefunBackup.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        config = null;
        researches = null;
        items = null;
        whitelist = null;
        instance = null;
        Messages.local = null;
        Files.CONFIG = null;
        Files.DATABASE = null;
        Files.ITEMS = null;
        Files.RESEARCHES = null;
        Files.WHITELIST = null;
        MultiBlock.list = null;
        Research.list = null;
        Research.researching = null;
        SlimefunItem.all = null;
        SlimefunItem.items = null;
        SlimefunItem.map_id = null;
        SlimefunItem.handlers = null;
        SlimefunItem.radioactive = null;
        Variables.damage = null;
        Variables.jump = null;
        Variables.mode = null;
        SlimefunGuide.history = null;
        Variables.altarinuse = null;
        Variables.enchanting = null;
        Variables.backpack = null;
        Variables.soulbound = null;
        Variables.blocks = null;
        Variables.cancelPlace = null;
        Variables.arrows = null;
        SlimefunCommand.arguments = null;
        SlimefunCommand.descriptions = null;
        SlimefunCommand.tabs = null;
        URID.objects = null;
        URID.ids = null;
        SlimefunItem.blockhandler = null;
        BlockMenuPreset.presets = null;
        BlockStorage.loaded_tickers = null;
        BlockStorage.ticking_chunks = null;
        BlockStorage.worlds = null;
        ChargableBlock.capacitors = null;
        ChargableBlock.max_charges = null;
        AContainer.processing = null;
        AContainer.progress = null;
        Slimefun.guide_handlers = null;
        Pedestals.recipes = null;
        Elevator.ignored = null;
        EnergyNet.listeners = null;
        EnergyNet.machines_input = null;
        EnergyNet.machines_output = null;
        EnergyNet.machines_storage = null;
        CargoNet.faces = null;
        BlockStorage.universal_inventories = null;
        TickerTask.block_timings = null;
        OreGenSystem.map = null;
        SlimefunGuide.contributors = null;
        GitHubConnector.connectors = null;
        ChestManipulator.listeners = null;
        ItemHash.digest = null;
        ItemHash.map = null;
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.closeInventory();
        }
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static Config getCfg() {
        return config;
    }

    public static Config getResearchCfg() {
        return researches;
    }

    public static Config getItemCfg() {
        return items;
    }

    public static Config getWhitelist() {
        return whitelist;
    }

    public static int randomize(int max) {
        if (max < 1) {
            return 0;
        }
        return CSCoreLib.randomizer().nextInt(max);
    }

    public static boolean chance(int max, int percentage) {
        if (max < 1) {
            return false;
        }
        return CSCoreLib.randomizer().nextInt(max) <= percentage;
    }

    public boolean isClearLagInstalled() {
        return this.clearlag;
    }

    public boolean isExoticGardenInstalled() {
        return this.exoticGarden;
    }

    public boolean isCoreProtectInstalled() {
        return this.coreProtect;
    }

    public CoreProtectAPI getCoreProtectAPI() {
        return this.coreProtectAPI;
    }
}

