/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.protection.modules;

import me.angeschossen.lands.api.integration.LandsIntegration;
import me.angeschossen.lands.api.land.Area;
import me.angeschossen.lands.api.land.LandWorld;
import me.angeschossen.lands.api.role.enums.RoleSetting;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionModule;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class LandsProtectionModule
implements ProtectionModule {
    private LandsIntegration landsIntegration;
    private final Plugin plugin;

    public LandsProtectionModule(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.landsIntegration = new LandsIntegration(this.plugin);
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, ProtectableAction action) {
        LandWorld landWorld = this.landsIntegration.getLandWorld(l.getWorld());
        if (landWorld == null) {
            return true;
        }
        Area area = landWorld.getArea(l);
        return area == null || area.canSetting(p.getUniqueId(), this.convert(action));
    }

    private RoleSetting convert(ProtectableAction protectableAction) {
        switch (protectableAction) {
            case PLACE_BLOCK: {
                return RoleSetting.BLOCK_PLACE;
            }
            case BREAK_BLOCK: {
                return RoleSetting.BLOCK_BREAK;
            }
            case ATTACK_PLAYER: {
                return RoleSetting.ATTACK_PLAYER;
            }
            case INTERACT_BLOCK: {
                return RoleSetting.INTERACT_CONTAINER;
            }
            case INTERACT_ENTITY: {
                return RoleSetting.INTERACT_VILLAGER;
            }
            case ATTACK_ENTITY: {
                return RoleSetting.ATTACK_ANIMAL;
            }
        }
        return RoleSetting.BLOCK_BREAK;
    }
}

