/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.localization;

import io.github.thebusybiscuit.slimefun4.core.services.localization.LanguageFile;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class Language {
    private final Map<LanguageFile, FileConfiguration> files = new EnumMap<LanguageFile, FileConfiguration>(LanguageFile.class);
    private final String id;
    private final ItemStack item;
    private double progress = -1.0;

    public Language(@Nonnull String id, @Nonnull String hash) {
        Validate.notNull((Object)id, (String)"A Language must have an id that is not null!");
        Validate.notNull((Object)hash, (String)"A Language must have a texture that is not null!");
        this.id = id;
        this.item = SlimefunUtils.getCustomHead(hash);
        SlimefunPlugin.getItemTextureService().setTexture(this.item, "_UI_LANGUAGE_" + id.toUpperCase(Locale.ROOT));
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public double getTranslationProgress() {
        if (this.id.equals("en")) {
            return 100.0;
        }
        if (this.progress < 0.0) {
            this.progress = SlimefunPlugin.getLocalization().calculateProgress(this);
        }
        return this.progress;
    }

    @Nullable
    FileConfiguration getFile(@Nonnull LanguageFile file) {
        return this.files.get((Object)file);
    }

    public void setFile(@Nonnull LanguageFile file, @Nonnull FileConfiguration config) {
        Validate.notNull((Object)((Object)file), (String)"The provided file should not be null.");
        Validate.notNull((Object)config, (String)"The provided config should not be null.");
        this.files.put(file, config);
    }

    @Nonnull
    public ItemStack getItem() {
        return this.item;
    }

    @Nonnull
    public String getName(@Nonnull Player p) {
        return SlimefunPlugin.getLocalization().getMessage(p, "languages." + this.id);
    }

    public boolean isDefault() {
        return this == SlimefunPlugin.getLocalization().getDefaultLanguage();
    }

    public String toString() {
        return "Language {id= " + this.id + ", default=" + this.isDefault() + " }";
    }

    @Nonnull
    public FileConfiguration[] getFiles() {
        return (FileConfiguration[])Arrays.stream(LanguageFile.valuesCached).map(this::getFile).toArray(FileConfiguration[]::new);
    }
}

