/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.players;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class PlayerList {
    private PlayerList() {
    }

    @Nonnull
    public static Stream<Player> stream() {
        return Bukkit.getOnlinePlayers().stream().map(Player.class::cast);
    }

    @Nonnull
    public static Optional<Player> findByName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return PlayerList.stream().filter(p -> p.getName().equalsIgnoreCase(name)).findAny();
    }

    @Nonnull
    public static Set<Player> findPermitted(@NonNull String permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return PlayerList.stream().filter(p -> p.hasPermission(permission)).collect(Collectors.toSet());
    }

    public static boolean isOnline(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return PlayerList.findByName(name).isPresent();
    }
}

