/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.ContributionsConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubActivityConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubIssuesConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubTask;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Translators;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.Plugin;

public class GitHubService {
    private final String repository;
    private final Set<GitHubConnector> connectors;
    private final ConcurrentMap<String, Contributor> contributors;
    private final Config uuidCache = new Config("plugins/Slimefun/cache/github/uuids.yml");
    private final Config texturesCache = new Config("plugins/Slimefun/cache/github/skins.yml");
    private boolean logging = false;
    private LocalDateTime lastUpdate = LocalDateTime.now();
    private int openIssues = 0;
    private int pendingPullRequests = 0;
    private int publicForks = 0;
    private int stargazers = 0;

    public GitHubService(@Nonnull String repository) {
        this.repository = repository;
        this.connectors = new HashSet<GitHubConnector>();
        this.contributors = new ConcurrentHashMap<String, Contributor>();
        this.loadConnectors(false);
    }

    public void start(@Nonnull SlimefunPlugin plugin) {
        long period = TimeUnit.HOURS.toMillis(1L);
        GitHubTask task = new GitHubTask(this);
        plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, (Runnable)task, 80L, period);
    }

    private void addDefaultContributors() {
        this.addContributor("Fuffles_", "&dArtist");
        this.addContributor("IMS_Art", "https://github.com/IAmSorryArt", "&dArtist", 0);
        this.addContributor("nahkd123", "&aWinner of the 2020 Addon Jam");
        new Translators(this);
    }

    private void addContributor(@Nonnull String name, @Nonnull String role) {
        Contributor contributor = new Contributor(name);
        contributor.setContributions(role, 0);
        contributor.setUniqueId(this.uuidCache.getUUID(name));
        this.contributors.put(name, contributor);
    }

    @Nonnull
    public Contributor addContributor(@Nonnull String minecraftName, @Nonnull String profileURL, @Nonnull String role, int commits) {
        Validate.notNull((Object)minecraftName, (String)"Minecraft username must not be null.");
        Validate.notNull((Object)profileURL, (String)"GitHub profile url must not be null.");
        Validate.notNull((Object)role, (String)"Role should not be null.");
        Validate.isTrue((commits >= 0 ? 1 : 0) != 0, (String)"Commit count cannot be negative.");
        String username = profileURL.substring(profileURL.lastIndexOf(47) + 1);
        Contributor contributor = this.contributors.computeIfAbsent(username, key -> new Contributor(minecraftName, profileURL));
        contributor.setContributions(role, commits);
        contributor.setUniqueId(this.uuidCache.getUUID(minecraftName));
        return contributor;
    }

    private void loadConnectors(boolean logging) {
        this.logging = logging;
        this.addDefaultContributors();
        this.connectors.add(new ContributionsConnector(this, "code", 1, this.repository, "developer"));
        this.connectors.add(new ContributionsConnector(this, "code2", 2, this.repository, "developer"));
        this.connectors.add(new ContributionsConnector(this, "code3", 3, this.repository, "developer"));
        this.connectors.add(new ContributionsConnector(this, "wiki", 1, "Slimefun/Wiki", "wiki"));
        this.connectors.add(new ContributionsConnector(this, "resourcepack", 1, "Slimefun/Resourcepack", "resourcepack"));
        this.connectors.add(new GitHubIssuesConnector(this, this.repository, (issues, pullRequests) -> {
            this.openIssues = issues;
            this.pendingPullRequests = pullRequests;
        }));
        this.connectors.add(new GitHubActivityConnector(this, this.repository, (forks, stars, date) -> {
            this.publicForks = forks;
            this.stargazers = stars;
            this.lastUpdate = date;
        }));
    }

    @Nonnull
    protected Set<GitHubConnector> getConnectors() {
        return this.connectors;
    }

    protected boolean isLoggingEnabled() {
        return this.logging;
    }

    @Nonnull
    public ConcurrentMap<String, Contributor> getContributors() {
        return this.contributors;
    }

    public int getForks() {
        return this.publicForks;
    }

    public int getStars() {
        return this.stargazers;
    }

    public int getOpenIssues() {
        return this.openIssues;
    }

    @Nonnull
    public String getRepository() {
        return this.repository;
    }

    public int getPendingPullRequests() {
        return this.pendingPullRequests;
    }

    @Nonnull
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    protected void saveCache() {
        for (Contributor contributor : this.contributors.values()) {
            String texture;
            Optional<UUID> uuid = contributor.getUniqueId();
            uuid.ifPresent(value -> this.uuidCache.setValue(contributor.getName(), value));
            if (!contributor.hasTexture() || (texture = contributor.getTexture(this)).equals(HeadTexture.UNKNOWN.getTexture())) continue;
            this.texturesCache.setValue(contributor.getName(), texture);
        }
        this.uuidCache.save();
        this.texturesCache.save();
    }

    @Nullable
    protected String getCachedTexture(@Nonnull String username) {
        return this.texturesCache.getString(username);
    }
}

