/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    public BlockListener(@Nonnull SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockPlaceExisting(BlockPlaceEvent e) {
        Block block = e.getBlock();
        if (e.getBlockReplacedState().getType().isAir()) {
            SlimefunItem sfItem = BlockStorage.check(block);
            if (sfItem != null && !SlimefunPlugin.getTickerTask().isDeletedSoon(block.getLocation())) {
                for (ItemStack item : sfItem.getDrops()) {
                    if (item == null || item.getType().isAir()) continue;
                    block.getWorld().dropItemNaturally(block.getLocation(), item);
                }
                BlockStorage.clearBlockInfo(block);
            }
        } else if (BlockStorage.hasBlockInfo(e.getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent e) {
        ItemStack item = e.getItemInHand();
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem != null && !(sfItem instanceof NotPlaceable) && Slimefun.isEnabled(e.getPlayer(), sfItem, true)) {
            if (!sfItem.canUse(e.getPlayer(), true)) {
                e.setCancelled(true);
            } else {
                if (SlimefunPlugin.getBlockDataService().isTileEntity(e.getBlock().getType())) {
                    SlimefunPlugin.getBlockDataService().setBlockData(e.getBlock(), sfItem.getId());
                }
                BlockStorage.addBlockInfo(e.getBlock(), "id", sfItem.getId(), true);
                sfItem.callItemHandler(BlockPlaceHandler.class, handler -> handler.onPlayerPlace(e));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (SlimefunPlugin.getIntegrations().isEventFaked((Event)e)) {
            return;
        }
        if (SlimefunPlugin.getIntegrations().isCustomBlock(e.getBlock())) {
            return;
        }
        if (SlimefunPlugin.getTickerTask().isDeletedSoon(e.getBlock().getLocation())) {
            return;
        }
        ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        this.checkForSensitiveBlockAbove(e, item);
        int fortune = this.getBonusDropsWithFortune(item, e.getBlock());
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!e.isCancelled() && !item.getType().isAir()) {
            this.callToolHandler(e, item, fortune, drops);
        }
        if (!e.isCancelled()) {
            this.callBlockHandler(e, item, drops);
        }
        this.dropItems(e, drops);
    }

    @ParametersAreNonnullByDefault
    private void callToolHandler(BlockBreakEvent e, ItemStack item, int fortune, List<ItemStack> drops) {
        SlimefunItem tool = SlimefunItem.getByItem(item);
        if (tool != null) {
            if (tool.canUse(e.getPlayer(), true)) {
                tool.callItemHandler(ToolUseHandler.class, handler -> handler.onToolUse(e, item, fortune, drops));
            } else {
                e.setCancelled(true);
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void callBlockHandler(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
        Optional<String> blockData;
        SlimefunItem sfItem = BlockStorage.check(e.getBlock());
        if (sfItem == null && SlimefunPlugin.getBlockDataService().isTileEntity(e.getBlock().getType()) && (blockData = SlimefunPlugin.getBlockDataService().getBlockData(e.getBlock())).isPresent()) {
            sfItem = SlimefunItem.getByID(blockData.get());
        }
        if (sfItem != null && !sfItem.useVanillaBlockBreaking()) {
            sfItem.callItemHandler(BlockBreakHandler.class, handler -> handler.onPlayerBreak(e, item, drops));
            if (e.isCancelled()) {
                return;
            }
            drops.addAll(sfItem.getDrops());
            BlockStorage.clearBlockInfo(e.getBlock());
        }
    }

    @ParametersAreNonnullByDefault
    private void dropItems(BlockBreakEvent e, List<ItemStack> drops) {
        if (!drops.isEmpty() && !e.isCancelled()) {
            SlimefunPlugin.getProtectionManager().logAction((OfflinePlayer)e.getPlayer(), e.getBlock(), ProtectableAction.BREAK_BLOCK);
            if (e.isDropItems()) {
                e.setDropItems(false);
                for (ItemStack drop : drops) {
                    if (drop == null || drop.getType() == Material.AIR) continue;
                    e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), drop);
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void checkForSensitiveBlockAbove(BlockBreakEvent e, ItemStack item) {
        SlimefunItem sfItem;
        Block blockAbove = e.getBlock().getRelative(BlockFace.UP);
        if (SlimefunTag.SENSITIVE_MATERIALS.isTagged(blockAbove.getType()) && (sfItem = BlockStorage.check(blockAbove)) != null && !sfItem.useVanillaBlockBreaking()) {
            BlockBreakEvent dummyEvent = new BlockBreakEvent(blockAbove, e.getPlayer());
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.addAll(sfItem.getDrops(e.getPlayer()));
            sfItem.callItemHandler(BlockBreakHandler.class, handler -> handler.onPlayerBreak(dummyEvent, item, drops));
            blockAbove.setType(Material.AIR);
            if (!dummyEvent.isCancelled() && dummyEvent.isDropItems()) {
                for (ItemStack drop : drops) {
                    if (drop == null || drop.getType().isAir()) continue;
                    blockAbove.getWorld().dropItemNaturally(blockAbove.getLocation(), drop);
                }
            }
            BlockStorage.clearBlockInfo(blockAbove);
        }
    }

    private int getBonusDropsWithFortune(@Nullable ItemStack item, @Nonnull Block b) {
        ItemMeta meta;
        int fortuneLevel;
        int amount = 1;
        if (item != null && !item.getType().isAir() && item.hasItemMeta() && (fortuneLevel = (meta = item.getItemMeta()).getEnchantLevel(Enchantment.LOOT_BONUS_BLOCKS)) > 0 && !meta.hasEnchant(Enchantment.SILK_TOUCH)) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            amount = Math.max(1, ((Random)random).nextInt(fortuneLevel + 2) - 1);
            amount = (b.getType() == Material.LAPIS_ORE ? 4 + ((Random)random).nextInt(5) : 1) * (amount + 1);
        }
        return amount;
    }
}

