/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.localization;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunBranch;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.core.services.localization.SupportedLanguage;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Localization;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class SlimefunLocalization
extends Localization
implements Keyed {
    protected SlimefunLocalization(@Nonnull SlimefunPlugin plugin) {
        super((Plugin)plugin);
    }

    @Nullable
    public abstract Language getLanguage(@Nonnull String var1);

    @Nullable
    public abstract Language getLanguage(@Nonnull Player var1);

    @Nullable
    public abstract Language getDefaultLanguage();

    protected abstract boolean hasLanguage(@Nonnull String var1);

    @Nonnull
    public abstract Collection<Language> getLanguages();

    protected abstract void addLanguage(@Nonnull String var1, @Nonnull String var2);

    protected void loadEmbeddedLanguages() {
        for (SupportedLanguage lang : SupportedLanguage.values()) {
            if (!lang.isReadyForRelease() && SlimefunPlugin.getUpdater().getBranch() == SlimefunBranch.STABLE) continue;
            this.addLanguage(lang.getLanguageId(), lang.getTexture());
        }
    }

    @Override
    @Nonnull
    public String getMessage(@Nonnull String key) {
        String message;
        Validate.notNull((Object)key, (String)"Message key must not be null!");
        Language language = this.getDefaultLanguage();
        String string = message = language == null ? null : language.getMessagesFile().getString(key);
        if (message == null) {
            Language fallback = this.getLanguage(SupportedLanguage.ENGLISH.getLanguageId());
            return fallback.getMessagesFile().getString(key);
        }
        return message;
    }

    @Nonnull
    public String getMessage(@Nonnull Player p, @Nonnull String key) {
        Validate.notNull((Object)p, (String)"Player must not be null!");
        Validate.notNull((Object)key, (String)"Message key must not be null!");
        Language language = this.getLanguage(p);
        if (language == null) {
            return "NO LANGUAGE FOUND";
        }
        String message = language.getMessagesFile().getString(key);
        if (message == null) {
            Language fallback = this.getLanguage(SupportedLanguage.ENGLISH.getLanguageId());
            return fallback.getMessagesFile().getString(key);
        }
        return message;
    }

    @Nonnull
    public List<String> getMessages(@Nonnull Player p, @Nonnull String key) {
        Validate.notNull((Object)p, (String)"Player should not be null.");
        Validate.notNull((Object)key, (String)"Message key cannot be null.");
        Language language = this.getLanguage(p);
        if (language == null) {
            return Collections.singletonList("NO LANGUAGE FOUND");
        }
        List messages = language.getMessagesFile().getStringList(key);
        if (messages.isEmpty()) {
            Language fallback = this.getLanguage(SupportedLanguage.ENGLISH.getLanguageId());
            return fallback.getMessagesFile().getStringList(key);
        }
        return messages;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public List<String> getMessages(Player p, String key, UnaryOperator<String> function) {
        Validate.notNull((Object)p, (String)"Player cannot be null.");
        Validate.notNull((Object)key, (String)"Message key cannot be null.");
        Validate.notNull(function, (String)"Function cannot be null.");
        List<String> messages = this.getMessages(p, key);
        messages.replaceAll(function);
        return messages;
    }

    @Nullable
    public String getResearchName(@Nonnull Player p, @Nonnull NamespacedKey key) {
        Validate.notNull((Object)p, (String)"Player must not be null.");
        Validate.notNull((Object)key, (String)"NamespacedKey cannot be null.");
        Language language = this.getLanguage(p);
        if (language == null || language.getResearchesFile() == null) {
            return null;
        }
        return language.getResearchesFile().getString(key.getNamespace() + '.' + key.getKey());
    }

    @Nullable
    public String getCategoryName(@Nonnull Player p, @Nonnull NamespacedKey key) {
        Validate.notNull((Object)p, (String)"Player must not be null.");
        Validate.notNull((Object)key, (String)"NamespacedKey cannot be null!");
        Language language = this.getLanguage(p);
        if (language == null || language.getCategoriesFile() == null) {
            return null;
        }
        return language.getCategoriesFile().getString(key.getNamespace() + '.' + key.getKey());
    }

    @Nullable
    public String getResourceString(@Nonnull Player p, @Nonnull String key) {
        String value;
        Validate.notNull((Object)p, (String)"Player should not be null!");
        Validate.notNull((Object)key, (String)"Message key should not be null!");
        Language language = this.getLanguage(p);
        String string = value = language != null && language.getResourcesFile() != null ? language.getResourcesFile().getString(key) : null;
        if (value != null) {
            return value;
        }
        Language fallback = this.getLanguage(SupportedLanguage.ENGLISH.getLanguageId());
        return fallback.getResourcesFile().getString(key);
    }

    @Nullable
    public ItemStack getRecipeTypeItem(@Nonnull Player p, @Nonnull RecipeType recipeType) {
        Validate.notNull((Object)p, (String)"Player cannot be null!");
        Validate.notNull((Object)recipeType, (String)"Recipe type cannot be null!");
        Language language = this.getLanguage(p);
        ItemStack item = recipeType.toItem();
        NamespacedKey key = recipeType.getKey();
        if (language == null || language.getRecipeTypesFile() == null || !language.getRecipeTypesFile().contains(key.getNamespace() + '.' + key.getKey())) {
            language = this.getLanguage("en");
        }
        if (!language.getRecipeTypesFile().contains(key.getNamespace() + '.' + key.getKey())) {
            return item;
        }
        FileConfiguration config = language.getRecipeTypesFile();
        return new CustomItem(item, meta -> {
            meta.setDisplayName(ChatColor.AQUA + config.getString(key.getNamespace() + "." + key.getKey() + ".name"));
            List lore = config.getStringList(key.getNamespace() + "." + key.getKey() + ".lore");
            lore.replaceAll(line -> ChatColor.GRAY + line);
            meta.setLore(lore);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        });
    }

    @Override
    public void sendMessage(@Nonnull CommandSender recipient, @Nonnull String key, boolean addPrefix) {
        String prefix;
        Validate.notNull((Object)recipient, (String)"Recipient cannot be null!");
        Validate.notNull((Object)key, (String)"Message key cannot be null!");
        String string = prefix = addPrefix ? this.getPrefix() : "";
        if (recipient instanceof Player) {
            recipient.sendMessage(ChatColors.color(prefix + this.getMessage((Player)recipient, key)));
        } else {
            recipient.sendMessage(ChatColor.stripColor((String)ChatColors.color(prefix + this.getMessage(key))));
        }
    }

    public void sendActionbarMessage(@Nonnull Player player, @Nonnull String key, boolean addPrefix) {
        Validate.notNull((Object)player, (String)"Player cannot be null!");
        Validate.notNull((Object)key, (String)"Message key cannot be null!");
        String prefix = addPrefix ? this.getPrefix() : "";
        String message = ChatColors.color(prefix + this.getMessage(player, key));
        BaseComponent[] components = TextComponent.fromLegacyText((String)message);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
    }

    @Override
    public void sendMessage(@Nonnull CommandSender recipient, @Nonnull String key) {
        this.sendMessage(recipient, key, true);
    }

    @ParametersAreNonnullByDefault
    public void sendMessage(CommandSender recipient, String key, UnaryOperator<String> function) {
        this.sendMessage(recipient, key, true, function);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void sendMessage(CommandSender recipient, String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix;
        if (SlimefunPlugin.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return;
        }
        String string = prefix = addPrefix ? this.getPrefix() : "";
        if (recipient instanceof Player) {
            recipient.sendMessage(ChatColors.color(prefix + (String)function.apply(this.getMessage((Player)recipient, key))));
        } else {
            recipient.sendMessage(ChatColor.stripColor((String)ChatColors.color(prefix + (String)function.apply(this.getMessage(key)))));
        }
    }

    @Override
    public void sendMessages(@Nonnull CommandSender recipient, @Nonnull String key) {
        String prefix = this.getPrefix();
        if (recipient instanceof Player) {
            for (String translation : this.getMessages((Player)recipient, key)) {
                String message = ChatColors.color(prefix + translation);
                recipient.sendMessage(message);
            }
        } else {
            for (String translation : this.getMessages(key)) {
                String message = ChatColors.color(prefix + translation);
                recipient.sendMessage(ChatColor.stripColor((String)message));
            }
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public void sendMessages(CommandSender recipient, String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix;
        String string = prefix = addPrefix ? this.getPrefix() : "";
        if (recipient instanceof Player) {
            for (String translation : this.getMessages((Player)recipient, key)) {
                String message = ChatColors.color(prefix + (String)function.apply(translation));
                recipient.sendMessage(message);
            }
        } else {
            for (String translation : this.getMessages(key)) {
                String message = ChatColors.color(prefix + (String)function.apply(translation));
                recipient.sendMessage(ChatColor.stripColor((String)message));
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void sendMessages(CommandSender recipient, String key, UnaryOperator<String> function) {
        this.sendMessages(recipient, key, true, function);
    }
}

