/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.enchanting;

import io.github.thebusybiscuit.slimefun4.api.events.AutoEnchantEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;

public class AutoEnchanter
extends AContainer {
    private final ItemSetting<Boolean> useEnchantLevelLimit = new ItemSetting<Boolean>(this, "use-enchant-level-limit", false);
    private final IntRangeSetting enchantLevelLimit = new IntRangeSetting(this, "enchant-level-limit", 0, 10, Short.MAX_VALUE);

    @ParametersAreNonnullByDefault
    public AutoEnchanter(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.useEnchantLevelLimit);
        this.addItemSetting(this.enchantLevelLimit);
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.GOLDEN_CHESTPLATE);
    }

    @Override
    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        for (int slot : this.getInputSlots()) {
            ItemStack target = menu.getItemInSlot(slot == this.getInputSlots()[0] ? this.getInputSlots()[1] : this.getInputSlots()[0]);
            if (!this.isEnchantable(target)) {
                return null;
            }
            AutoEnchantEvent event = new AutoEnchantEvent(target);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return null;
            }
            ItemStack item = menu.getItemInSlot(slot);
            if (item == null || item.getType() != Material.ENCHANTED_BOOK || target == null) continue;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            int amount = 0;
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)item.getItemMeta();
            for (Map.Entry e : meta.getStoredEnchants().entrySet()) {
                if (!((Enchantment)e.getKey()).canEnchantItem(target)) continue;
                if (!this.useEnchantLevelLimit.getValue().booleanValue() || (Integer)this.enchantLevelLimit.getValue() >= (Integer)e.getValue()) {
                    ++amount;
                    enchantments.put((Enchantment)e.getKey(), (Integer)e.getValue());
                    continue;
                }
                if (menu.toInventory().getViewers().isEmpty()) continue;
                String string2 = ChatColors.color(SlimefunPlugin.getLocalization().getMessage("messages.above-limit-level"));
                string2 = string2.replace("%level%", String.valueOf(this.enchantLevelLimit.getValue()));
                CustomItem progressBar = new CustomItem(Material.BARRIER, " ", string2);
                menu.replaceExistingItem(22, progressBar);
                return null;
            }
            if (amount > 0) {
                ItemStack enchantedItem = target.clone();
                enchantedItem.setAmount(1);
                for (Map.Entry entry : enchantments.entrySet()) {
                    enchantedItem.addUnsafeEnchantment((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue());
                }
                MachineRecipe recipe = new MachineRecipe(75 * amount / this.getSpeed(), new ItemStack[]{target, item}, new ItemStack[]{enchantedItem, new ItemStack(Material.BOOK)});
                if (!InvUtils.fitAll(menu.toInventory(), recipe.getOutput(), this.getOutputSlots())) {
                    return null;
                }
                for (int inputSlot : this.getInputSlots()) {
                    menu.consumeItem(inputSlot);
                }
                return recipe;
            }
            return null;
        }
        return null;
    }

    private boolean isEnchantable(@Nullable ItemStack item) {
        if (item != null && item.getType() != Material.ENCHANTED_BOOK) {
            SlimefunItem sfItem = SlimefunItem.getByItem(item);
            return sfItem == null || sfItem.isEnchantable();
        }
        return false;
    }

    @Override
    public String getMachineIdentifier() {
        return "AUTO_ENCHANTER";
    }
}

