/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.attributes;

import io.github.thebusybiscuit.slimefun4.core.attributes.ItemAttribute;
import io.github.thebusybiscuit.slimefun4.utils.UnbreakingAlgorithm;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public interface DamageableItem
extends ItemAttribute {
    public boolean isDamageable();

    default public void damageItem(@Nonnull Player p, @Nullable ItemStack item) {
        if (this.isDamageable() && item != null && !item.getType().isAir() && item.getAmount() > 0) {
            int unbreakingLevel = item.getEnchantmentLevel(Enchantment.DURABILITY);
            if (unbreakingLevel > 0 && this.evaluateUnbreakingEnchantment(unbreakingLevel)) {
                return;
            }
            ItemMeta meta = item.getItemMeta();
            if (!meta.isUnbreakable()) {
                Damageable damageable = (Damageable)meta;
                if (damageable.getDamage() >= item.getType().getMaxDurability()) {
                    p.playSound(p.getEyeLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                    item.setAmount(0);
                } else {
                    damageable.setDamage(damageable.getDamage() + 1);
                    item.setItemMeta(meta);
                }
            }
        }
    }

    default public boolean evaluateUnbreakingEnchantment(int unbreakingLevel) {
        return UnbreakingAlgorithm.TOOLS.evaluate(unbreakingLevel);
    }
}

