/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.AbstractMonsterSpawner;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Material;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class RepairedSpawner
extends AbstractMonsterSpawner {
    private final ItemSetting<Boolean> allowSpawnEggs = new ItemSetting<Boolean>(this, "allow-spawn-eggs", true);

    @ParametersAreNonnullByDefault
    public RepairedSpawner(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.allowSpawnEggs);
        this.addItemHandler(this.onInteract());
        this.addItemHandler(this.onPlace());
    }

    @Nonnull
    private BlockUseHandler onInteract() {
        return e -> {
            if (!this.allowSpawnEggs.getValue().booleanValue() && SlimefunTag.SPAWN_EGGS.isTagged(e.getItem().getType())) {
                e.cancel();
            }
        };
    }

    @Nonnull
    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(true){

            @Override
            public void onPlayerPlace(BlockPlaceEvent e) {
                this.onPlace(e.getItemInHand(), (BlockEvent)e);
            }

            @Override
            public void onBlockPlacerPlace(BlockPlacerPlaceEvent e) {
                this.onPlace(e.getItemStack(), e);
            }

            @ParametersAreNonnullByDefault
            private void onPlace(ItemStack item, BlockEvent e) {
                if (e.getBlock().getType() == Material.SPAWNER) {
                    RepairedSpawner.this.getEntityType(item).ifPresent(entity -> {
                        CreatureSpawner spawner = (CreatureSpawner)e.getBlock().getState();
                        spawner.setSpawnedType(entity);
                        spawner.update(true, false);
                    });
                }
            }
        };
    }

    @Override
    public Collection<ItemStack> getDrops() {
        return new ArrayList<ItemStack>();
    }
}

