/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.researching;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerPreResearchEvent;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.researching.PlayerResearchTask;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class Research
implements Keyed {
    private final NamespacedKey key;
    private final int id;
    private final String name;
    private boolean enabled = true;
    private int cost;
    private final List<SlimefunItem> items = new LinkedList<SlimefunItem>();

    public Research(@Nonnull NamespacedKey key, int id, @Nonnull String defaultName, int defaultCost) {
        Validate.notNull((Object)key, (String)"A NamespacedKey must be provided");
        Validate.notNull((Object)defaultName, (String)"A default name must be specified");
        this.key = key;
        this.id = id;
        this.name = defaultName;
        this.cost = defaultCost;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public boolean isEnabled() {
        return SlimefunPlugin.getRegistry().isResearchingEnabled() && this.enabled;
    }

    @Deprecated
    public int getID() {
        return this.id;
    }

    @Nonnull
    public String getName(@Nonnull Player p) {
        String localized = SlimefunPlugin.getLocalization().getResearchName(p, this.key);
        return localized != null ? localized : this.name;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        if (cost < 0) {
            throw new IllegalArgumentException("Research cost must be zero or greater!");
        }
        this.cost = cost;
    }

    public void addItems(SlimefunItem ... items) {
        for (SlimefunItem item : items) {
            if (item == null) continue;
            item.setResearch(this);
        }
    }

    @Nonnull
    public Research addItems(ItemStack ... items) {
        for (ItemStack item : items) {
            SlimefunItem sfItem = SlimefunItem.getByItem(item);
            if (sfItem == null) continue;
            sfItem.setResearch(this);
        }
        return this;
    }

    @Nonnull
    public List<SlimefunItem> getAffectedItems() {
        return this.items;
    }

    @ParametersAreNonnullByDefault
    public void unlockFromGuide(SlimefunGuideImplementation guide, Player player, PlayerProfile profile, SlimefunItem sfItem, Category category, int page) {
        if (!SlimefunPlugin.getRegistry().getCurrentlyResearchingPlayers().contains(player.getUniqueId())) {
            if (profile.hasUnlocked(this)) {
                guide.openCategory(profile, category, page);
            } else {
                PlayerPreResearchEvent event = new PlayerPreResearchEvent(player, this, sfItem);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    if (this.canUnlock(player)) {
                        guide.unlockItem(player, sfItem, pl -> guide.openCategory(profile, category, page));
                    } else {
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)player, "messages.not-enough-xp", true);
                    }
                }
            }
        }
    }

    public boolean canUnlock(@Nonnull Player p) {
        if (!this.isEnabled()) {
            return true;
        }
        boolean creativeResearch = p.getGameMode() == GameMode.CREATIVE && SlimefunPlugin.getRegistry().isFreeCreativeResearchingEnabled();
        return creativeResearch || p.getLevel() >= this.cost;
    }

    public void unlock(@Nonnull Player p, boolean instant) {
        this.unlock(p, instant, null);
    }

    public void unlock(@Nonnull Player p, boolean isInstant, @Nullable Consumer<Player> callback) {
        PlayerProfile.get((OfflinePlayer)p, new PlayerResearchTask(this, isInstant, callback));
    }

    public void register() {
        SlimefunPlugin.getResearchCfg().setDefaultValue("enable-researching", true);
        String path = this.key.getNamespace() + '.' + this.key.getKey();
        if (SlimefunPlugin.getResearchCfg().contains(path + ".enabled") && !SlimefunPlugin.getResearchCfg().getBoolean(path + ".enabled")) {
            for (SlimefunItem item : new ArrayList<SlimefunItem>(this.items)) {
                if (item == null) continue;
                item.setResearch(null);
            }
            this.enabled = false;
            return;
        }
        SlimefunPlugin.getResearchCfg().setDefaultValue(path + ".cost", this.getCost());
        SlimefunPlugin.getResearchCfg().setDefaultValue(path + ".enabled", true);
        this.setCost(SlimefunPlugin.getResearchCfg().getInt(path + ".cost"));
        this.enabled = true;
        SlimefunPlugin.getRegistry().getResearches().add(this);
    }

    @Nonnull
    public static Optional<Research> getResearch(@Nullable NamespacedKey key) {
        if (key == null) {
            return Optional.empty();
        }
        for (Research research : SlimefunPlugin.getRegistry().getResearches()) {
            if (!research.getKey().equals((Object)key)) continue;
            return Optional.of(research);
        }
        return Optional.empty();
    }

    public String toString() {
        return "Research (" + this.getKey() + ')';
    }
}

