/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest.apache;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.ProgressMonitor;
import java.io.IOException;
import java.io.OutputStream;

class MonitoringStream
extends OutputStream {
    private final OutputStream out;
    private volatile long written = 0L;
    private long length;
    private String fieldName;
    private String fileName;
    private ProgressMonitor monitor;

    public MonitoringStream(OutputStream out, long length, String fieldName, String fileName, ProgressMonitor monitor) {
        this.out = out;
        this.length = length;
        this.fieldName = fieldName;
        this.fileName = fileName;
        this.monitor = monitor;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.written;
        this.monitor.accept(this.fieldName, this.fileName, this.written, this.length);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.written += (long)b.length;
        this.monitor.accept(this.fieldName, this.fileName, this.written, this.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.written += (long)len;
        this.monitor.accept(this.fieldName, this.fileName, this.written, this.length);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

