/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.enchanting;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookBinder
extends AContainer {
    private final ItemSetting<Boolean> bypassVanillaMaxLevel = new ItemSetting<Boolean>(this, "bypass-vanilla-max-level", false);
    private final ItemSetting<Boolean> hasCustomMaxLevel = new ItemSetting<Boolean>(this, "has-custom-max-level", false);
    private final ItemSetting<Integer> customMaxLevel = new IntRangeSetting(this, "custom-max-level", 0, 15, Integer.MAX_VALUE);

    @ParametersAreNonnullByDefault
    public BookBinder(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.bypassVanillaMaxLevel, this.hasCustomMaxLevel, this.customMaxLevel);
    }

    @Override
    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        for (int slot : this.getInputSlots()) {
            Map storedTargetEnchantments;
            ItemStack target = menu.getItemInSlot(slot == this.getInputSlots()[0] ? this.getInputSlots()[1] : this.getInputSlots()[0]);
            ItemStack item = menu.getItemInSlot(slot);
            if (!this.isCompatible(item) || !this.isCompatible(target)) continue;
            EnchantmentStorageMeta itemMeta = (EnchantmentStorageMeta)item.getItemMeta();
            EnchantmentStorageMeta targetMeta = (EnchantmentStorageMeta)target.getItemMeta();
            Map storedItemEnchantments = itemMeta.getStoredEnchants();
            Map<Enchantment, Integer> enchantments = this.combineEnchantments(storedItemEnchantments, storedTargetEnchantments = targetMeta.getStoredEnchants());
            if (enchantments.size() > 0) {
                ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
                EnchantmentStorageMeta enchantMeta = (EnchantmentStorageMeta)book.getItemMeta();
                for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                    enchantMeta.addStoredEnchant(entry.getKey(), entry.getValue().intValue(), this.bypassVanillaMaxLevel.getValue().booleanValue());
                }
                if (enchantMeta.getStoredEnchants().isEmpty()) {
                    return null;
                }
                book.setItemMeta((ItemMeta)enchantMeta);
                MachineRecipe recipe = new MachineRecipe(25 * (enchantments.size() / this.getSpeed()), new ItemStack[]{target, item}, new ItemStack[]{book});
                if (!InvUtils.fitAll(menu.toInventory(), recipe.getOutput(), this.getOutputSlots())) {
                    return null;
                }
                for (int inputSlot : this.getInputSlots()) {
                    menu.consumeItem(inputSlot);
                }
                return recipe;
            }
            return null;
        }
        return null;
    }

    private boolean isCompatible(@Nullable ItemStack item) {
        return item != null && item.getType() == Material.ENCHANTED_BOOK;
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.IRON_CHESTPLATE);
    }

    @Override
    public String getMachineIdentifier() {
        return "BOOK_BINDER";
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private Map<Enchantment, Integer> combineEnchantments(Map<Enchantment, Integer> ech1, Map<Enchantment, Integer> ech2) {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        boolean conflicts = false;
        enchantments.putAll(ech1);
        for (Map.Entry<Enchantment, Integer> entry : ech2.entrySet()) {
            for (Map.Entry conflictsWith : enchantments.entrySet()) {
                if (!entry.getKey().conflictsWith((Enchantment)conflictsWith.getKey()) || entry.getKey().equals(conflictsWith.getKey())) continue;
                conflicts = true;
            }
            if (conflicts) continue;
            enchantments.merge(entry.getKey(), entry.getValue(), (a, b) -> {
                int enchantMaxLevel = ((Enchantment)entry.getKey()).getMaxLevel();
                if (a.intValue() == b.intValue()) {
                    if (enchantMaxLevel <= a && !this.bypassVanillaMaxLevel.getValue().booleanValue()) {
                        return enchantMaxLevel;
                    }
                    if (this.hasCustomMaxLevel.getValue().booleanValue()) {
                        return a + 1 > this.customMaxLevel.getValue() ? this.customMaxLevel.getValue() : a + 1;
                    }
                    return a + 1;
                }
                int highestLevel = Math.max(a, b);
                if (enchantMaxLevel <= highestLevel && !this.bypassVanillaMaxLevel.getValue().booleanValue()) {
                    return enchantMaxLevel;
                }
                if (this.hasCustomMaxLevel.getValue().booleanValue()) {
                    return highestLevel > this.customMaxLevel.getValue() ? this.customMaxLevel.getValue() : highestLevel;
                }
                return highestLevel;
            });
        }
        return enchantments;
    }
}

