/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide.options;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerLanguageChangeEvent;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Optional;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;

class PlayerLanguageOption
implements SlimefunGuideOption<String> {
    PlayerLanguageOption() {
    }

    @Override
    public SlimefunAddon getAddon() {
        return SlimefunPlugin.instance();
    }

    public NamespacedKey getKey() {
        return SlimefunPlugin.getLocalization().getKey();
    }

    @Override
    public Optional<ItemStack> getDisplayItem(Player p, ItemStack guide) {
        if (SlimefunPlugin.getLocalization().isEnabled()) {
            Language language = SlimefunPlugin.getLocalization().getLanguage(p);
            String languageName = language.isDefault() ? SlimefunPlugin.getLocalization().getMessage(p, "languages.default") + ChatColor.DARK_GRAY + " (" + language.getName(p) + ")" : SlimefunPlugin.getLocalization().getMessage(p, "languages." + language.getId());
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            lore.add("&e&o" + SlimefunPlugin.getLocalization().getMessage(p, "guide.work-in-progress"));
            lore.add("");
            lore.addAll(SlimefunPlugin.getLocalization().getMessages(p, "guide.languages.description", msg -> msg.replace("%contributors%", String.valueOf(SlimefunPlugin.getGitHubService().getContributors().size()))));
            lore.add("");
            lore.add("&7\u21e8 &e" + SlimefunPlugin.getLocalization().getMessage(p, "guide.languages.change"));
            CustomItem item = new CustomItem(language.getItem(), "&7" + SlimefunPlugin.getLocalization().getMessage(p, "guide.languages.selected-language") + " &a" + languageName, lore.toArray(new String[0]));
            return Optional.of(item);
        }
        return Optional.empty();
    }

    @Override
    public void onClick(Player p, ItemStack guide) {
        this.openLanguageSelection(p, guide);
    }

    @Override
    public Optional<String> getSelectedOption(Player p, ItemStack guide) {
        return Optional.of(SlimefunPlugin.getLocalization().getLanguage(p).getId());
    }

    @Override
    public void setSelectedOption(Player p, ItemStack guide, String value) {
        if (value == null) {
            PersistentDataAPI.remove((PersistentDataHolder)p, this.getKey());
        } else {
            PersistentDataAPI.setString((PersistentDataHolder)p, this.getKey(), value);
        }
    }

    private void openLanguageSelection(Player p, ItemStack guide) {
        ChestMenu menu = new ChestMenu(SlimefunPlugin.getLocalization().getMessage(p, "guide.title.languages"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f));
        for (int i2 = 0; i2 < 9; ++i2) {
            if (i2 == 1) {
                menu.addItem(1, ChestMenuUtils.getBackButton(p, "", "&7" + SlimefunPlugin.getLocalization().getMessage(p, "guide.back.settings")), (pl, slot, item, action) -> {
                    SlimefunGuideSettings.openSettings(pl, guide);
                    return false;
                });
                continue;
            }
            if (i2 == 7) {
                menu.addItem(7, new CustomItem(SlimefunUtils.getCustomHead(HeadTexture.ADD_NEW_LANGUAGE.getTexture()), SlimefunPlugin.getLocalization().getMessage(p, "guide.languages.translations.name"), "", "&7\u21e8 &e" + SlimefunPlugin.getLocalization().getMessage(p, "guide.languages.translations.lore")), (pl, slot, item, action) -> {
                    ChatUtils.sendURL((CommandSender)pl, "https://github.com/Slimefun/Slimefun4/wiki/Translating-Slimefun");
                    pl.closeInventory();
                    return false;
                });
                continue;
            }
            menu.addItem(i2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        Language defaultLanguage = SlimefunPlugin.getLocalization().getDefaultLanguage();
        String defaultLanguageString = SlimefunPlugin.getLocalization().getMessage(p, "languages.default");
        menu.addItem(9, new CustomItem(defaultLanguage.getItem(), ChatColor.GRAY + defaultLanguageString + ChatColor.DARK_GRAY + " (" + defaultLanguage.getName(p) + ")", "", "&7\u21e8 &e" + SlimefunPlugin.getLocalization().getMessage(p, "guide.languages.select-default")), (pl, i, item, action) -> {
            SlimefunPlugin.instance().getServer().getPluginManager().callEvent((Event)new PlayerLanguageChangeEvent(pl, SlimefunPlugin.getLocalization().getLanguage(pl), defaultLanguage));
            this.setSelectedOption(pl, guide, null);
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)pl, "guide.languages.updated", msg -> msg.replace("%lang%", defaultLanguageString));
            SlimefunGuideSettings.openSettings(pl, guide);
            return false;
        });
        int slot2 = 10;
        for (Language language : SlimefunPlugin.getLocalization().getLanguages()) {
            menu.addItem(slot2, new CustomItem(language.getItem(), ChatColor.GREEN + language.getName(p), "&b" + language.getTranslationProgress() + '%', "", "&7\u21e8 &e" + SlimefunPlugin.getLocalization().getMessage(p, "guide.languages.select")), (pl, i, item, action) -> {
                SlimefunPlugin.instance().getServer().getPluginManager().callEvent((Event)new PlayerLanguageChangeEvent(pl, SlimefunPlugin.getLocalization().getLanguage(pl), language));
                this.setSelectedOption(pl, guide, language.getId());
                String name = language.getName(pl);
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)pl, "guide.languages.updated", msg -> msg.replace("%lang%", name));
                SlimefunGuideSettings.openSettings(pl, guide);
                return false;
            });
            ++slot2;
        }
        menu.open(p);
    }
}

