/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.apache.commons.lang.Validate;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class PermissionsService {
    private final Map<String, String> permissions = new HashMap<String, String>();
    private final Config config;

    public PermissionsService(@Nonnull SlimefunPlugin plugin) {
        this.config = new Config((Plugin)plugin, "permissions.yml");
        this.config.getConfiguration().options().header("This file is used to assign permission nodes to items from Slimefun or any of its addons.\nTo assign an item a certain permission node you simply have to set the 'permission' attribute\nto your desired permission node. You can also customize the text that is displayed when a Player does not have that permission.");
        this.config.getConfiguration().options().copyHeader(true);
    }

    public void register(@Nonnull Iterable<SlimefunItem> items, boolean save) {
        for (SlimefunItem item : items) {
            if (item == null) continue;
            String path = item.getId() + ".permission";
            this.config.setDefaultValue(path, "none");
            this.config.setDefaultValue(item.getId() + ".lore", new String[]{"&rYou do not have the permission", "&rto access this item."});
            this.permissions.put(item.getId(), this.config.getString(path));
        }
        if (save) {
            this.config.save();
        }
    }

    public boolean hasPermission(Permissible p, SlimefunItem item) {
        if (item == null) {
            return true;
        }
        String permission = this.permissions.get(item.getId());
        return permission == null || permission.equals("none") || p.hasPermission(permission);
    }

    @Nonnull
    public Optional<String> getPermission(@Nonnull SlimefunItem item) {
        Validate.notNull((Object)item, (String)"Cannot get permissions for null");
        String permission = this.permissions.get(item.getId());
        if (permission == null || permission.equals("none")) {
            return Optional.empty();
        }
        return Optional.of(permission);
    }

    public void setPermission(@Nonnull SlimefunItem item, @Nullable String permission) {
        Validate.notNull((Object)item, (String)"You cannot set the permission for null");
        this.permissions.put(item.getId(), permission != null ? permission : "none");
    }

    public void save() {
        for (Map.Entry<String, String> entry : this.permissions.entrySet()) {
            this.config.setValue(entry.getKey() + ".permission", entry.getValue());
        }
        this.config.save();
    }

    @Nonnull
    public List<String> getLore(@Nonnull SlimefunItem item) {
        return this.config.getStringList(item.getId() + ".lore");
    }
}

