/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.holograms;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;

class Hologram {
    private static final long EXPIRES_AFTER = TimeUnit.MINUTES.toMillis(10L);
    private final UUID uniqueId;
    private long lastAccess;
    private String label;

    Hologram(@Nonnull UUID uniqueId) {
        this.uniqueId = uniqueId;
        this.lastAccess = System.currentTimeMillis();
    }

    @Nullable
    ArmorStand getArmorStand() {
        Entity n = Bukkit.getEntity((UUID)this.uniqueId);
        if (n instanceof ArmorStand && n.isValid()) {
            this.lastAccess = System.currentTimeMillis();
            return (ArmorStand)n;
        }
        this.lastAccess = 0L;
        return null;
    }

    boolean hasDespawned() {
        return this.getArmorStand() == null;
    }

    boolean hasExpired() {
        return System.currentTimeMillis() - this.lastAccess > EXPIRES_AFTER;
    }

    void setLabel(@Nullable String label) {
        if (Objects.equals(this.label, label)) {
            this.lastAccess = System.currentTimeMillis();
        } else {
            this.label = label;
            ArmorStand entity = this.getArmorStand();
            if (entity != null) {
                if (label != null) {
                    entity.setCustomNameVisible(true);
                    entity.setCustomName(label);
                } else {
                    entity.setCustomNameVisible(false);
                    entity.setCustomName(null);
                }
            }
        }
    }

    void remove() {
        ArmorStand armorstand = this.getArmorStand();
        if (armorstand != null) {
            this.lastAccess = 0L;
            armorstand.remove();
        }
    }
}

